
Type Vector2

	Global _zero:Vector2 = Vector2.Create(0, 0)
	Global _one:Vector2 = Vector2.Create(1, 1)
	Global _unitX:Vector2 = Vector2.Create(1, 0)
	Global _unitY:Vector2 = Vector2.Create(0, 1)
	
	Field X:Float
	Field Y:Float
	
	Method New() 

	End Method
	
	Function Zero:Vector2() 
		Return _zero.Copy() 
	End Function
	
	Function One:Vector2() 
		Return _one.Copy() 
	End Function
	
	Function UnitX:Vector2() 
		Return _unitX.Copy() 
	End Function
	
	Function UnitY:Vector2() 
		Return _unitY.Copy() 
	End Function
	
	Function Create:Vector2(x:Float, y:Float) 
		Local v:Vector2 = New Vector2
		v.X = x
		v.Y = y
		Return v
	End Function
	
	Function InitVector2() 
		_zero = Create(0, 0) 
		_one = Create(1, 1) 
		_unitX = Create(1, 0) 
		_unitY = Create(0, 1) 
	End Function
	
'#Region Public methods	
	rem
	bbdoc: returns the length of the vector
	end rem
	Method Length:Float() 
		Local num:Float = (X * X) + (Y * Y) 
		Return Sqr(num) 
	End Method
	
	rem
	bbdoc: returns the quadrance of a vector
	end rem
	Method LengthSquared:Float() 
		Return (X * X) + (Y * Y) 
	End Method
	
	Method Normalize() 
		Local num2:Float = (X * X) + (Y * Y) 
		Local num:Float = 1.0 / Float(Sqr(Double(num2))) 
		X = X * num
		y = Y * num
	End Method
	
	Method Scale:Vector2(scalar:Float) 
		X:*scalar
		Y:*scalar
		Return Self
	End Method
	
	Method Subtract:Vector2(vector:Vector2) 
		X:-vector.X
		Y:-vector.Y
		Return Self
	End Method
	
	Method Add:Vector2(vector:Vector2) 
		X:+vector.X
		Y:+vector.Y
		Return Self
	End Method
	
	Method Multiply:Vector2(vector:Vector2) 
		X:*vector.X
		Y:*vector.Y
		Return Self
	End Method
	
	Method Divide:Vector2(vector:Vector2) 
		X:/vector.X
		Y:/vector.Y
		Return Self
	End Method
	
	rem
	bbdoc: sets the vector's components to the values of 'v'
	end rem
	Method Set(v:Vector2) 
		X = v.X
		Y = v.Y
	End Method
	
	Method SetParts(vx:Float, vy:Float) 
		X = vx
		Y = vy
	End Method
	
	Method Copy:Vector2() 
		Return Vector2.Create(X, Y) 
	End Method
'#End Region 

'#Region Public Functions

	Function Lerp:Vector2(value1:Vector2, value2:Vector2, amount:Float) 
		Local v:Vector2 = Vector2.Zero() 
		v.X = value1.X + ((value2.X - value1.X) * amount) 
		v.Y = value1.Y + ((value2.Y - value1.Y) * amount) 
		Return v
	End Function
	
	Function LerpRef(value1:Vector2, value2:Vector2, amount:Float, result:Vector2)
		result.X = value1.X + ((value2.X - value1.X) * amount)
		result.Y = value1.Y + ((value2.Y - value1.Y) * amount)
	End Function
	
	Function NormalizeRef(value:Vector2, result:Vector2) 
		Local num2:Float = (value.X * value.X) + (value.Y * value.Y) 
		Local num:Float = 1.0 / Sqr(num2) 
		result.X = value.X * num
		result.Y = value.Y * num
	End Function
	
	Function AddVectorsRef(value1:Vector2, value2:Vector2, result:Vector2)
		result.X = value1.X + value2.X
		result.Y = value1.Y + value2.Y
	End Function
	
	Function Distance:Float(value1:Vector2, value2:Vector2) 
		Local num2:Float = value1.X - value2.X
		Local num:Float = value1.Y - value2.Y
		Local num3:Float = (num2 * num2) + (num * num) 
		Return Sqr(num3) 
	End Function
	
	Function DistanceSquared:Float(value1:Vector2, value2:Vector2) 
		Local num2:Float = value1.X - value2.X
		Local num:Float = value1.Y - value2.Y
		Return (num2 * num2) + (num * num) 
	End Function
	
	Function Dot:Float(value1:Vector2, value2:Vector2) 
		Return (value1.X * value2.X) + (value1.Y * value2.Y) 
	End Function
	
	Function AddVectors:Vector2(value1:Vector2, value2:Vector2) 
		Local vector:Vector2 = Create(0, 0) 
		vector.X = value1.X + value2.X
		vector.Y = value1.Y + value2.Y
		Return vector
	End Function
	
	Function SubtractVectors:Vector2(value1:Vector2, value2:Vector2) 
		Local vector:Vector2 = Create(0, 0) 
		vector.X = value1.X - value2.X
		vector.Y = value1.Y - value2.Y
		Return vector
	End Function
	
	Function SubtractVectorsRef(value1:Vector2, value2:Vector2, result:Vector2) 
		result.X = value1.X - value2.X
		result.Y = value1.Y - value2.Y
	End Function
	
	Function DividVectors:Vector2(value1:Vector2, value2:Vector2) 
		Local vector:Vector2 = Create(0, 0) 
		vector.X = value1.X / value2.X
		vector.Y = value1.Y / value2.Y
		Return vector
	End Function
	
	
	Method MultiplyVectors:Vector2(value1:Vector2, value2:Vector2) 
		Local vector:Vector2 = Create(0, 0) 
		vector.X = value1.X * value2.X
		vector.Y = value1.Y * value2.Y
		Return vector
	End Method
	
	Function ScaleVector:Vector2(value1:Vector2, scaleFactor:Float) 
		Local vector:Vector2 = zero() 
		vector.X = value1.X * scaleFactor
		vector.Y = value1.Y * scaleFactor
		Return vector
	End Function
	
	Function TransformRef(position:Vector2, matrix:TMatrix, result:Vector2) 
		Local num2:Float = ((position.X * matrix.M11) + (position.Y * matrix.M21)) + matrix.M41
        Local num:Float = ((position.X * matrix.M12) + (position.Y * matrix.M22)) + matrix.M42
        result.X = num2
        result.Y = num
	End Function
	
	
	Function TransformNormalRef(normal:Vector2, matrix:TMatrix, result:Vector2)
		Local num2:Float = (normal.X * matrix.M11) + (normal.Y * matrix.M21) 
		Local num:Float = (normal.X * matrix.M12) + (normal.Y * matrix.M22) 
		result.X = num2
		result.Y = num
	End Function
	
	Function ScaleRef(value1:Vector2, scaleFactor:Float, result:Vector2) 
		result.X = value1.x * scaleFactor
		result.Y = value1.Y * scaleFactor
	End Function
	
	'utility functions
	?debug
	Function DebugPrintList(v:Vector2[] , listname:String = "v: ") 
		For Local vector:Vector2 = EachIn v
			DebugLog listname + vector.ToString() 
		Next
	End Function
	?
'#End Region 
	
'#Region Object Overrides
	Method ToString:String() 
		Return "{X: " + X + " Y: " + Y + "}"
	End Method
	
	Method Equals:Int(other:Vector2) 
		If other.X = X Then
			Return Y = other.Y
		End If
		Return False
	End Method
'#End Region 
End Type
