
Type TMatrix

	Global _identity:TMatrix = TMatrix.Create(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1) 
	Field M11:Float
	Field M12:Float
	Field M13:Float
	Field M14:Float
	Field M21:Float
	Field M22:Float
	Field M23:Float
	Field M24:Float
	Field M31:Float
	Field M32:Float
	Field M33:Float
	Field M34:Float
	Field M41:Float
	Field M42:Float
	Field M43:Float
	Field M44:Float
	
'#Region Constructors
	Function Create:TMatrix(m11:Float, m12:Float, m13:Float, m14:Float, m21:Float, m22:Float, m23:Float, m24:Float, m31:Float, m32:Float, m33:Float, m34:Float, m41:Float, m42:Float, m43:Float, m44:Float) 
		Local this:TMatrix = New TMatrix
	        this.M11 = m11
            this.M12 = m12
            this.M13 = m13
            this.M14 = m14
            this.M21 = m21
            this.M22 = m22
            this.M23 = m23
            this.M24 = m24
            this.M31 = m31
            this.M32 = m32
            this.M33 = m33
            this.M34 = m34
            this.M41 = m41
            this.M42 = m42
            this.M43 = m43
            this.M44 = m44
			
			Return this
	End Function
	
	Function CreateRotationZ:TMatrix(radians:Float) 
		Local matrix:TMatrix = New TMatrix
		Local num2:Float = Cos(MathHelper.ToDegrees(radians)) 
		Local num:Float = Sin(MathHelper.ToDegrees(radians)) 
		 matrix.M11 = num2
         matrix.M12 = num
         matrix.M13 = 0
         matrix.M14 = 0
         matrix.M21 = -num
         matrix.M22 = num2
         matrix.M23 = 0
         matrix.M24 = 0
         matrix.M31 = 0
         matrix.M32 = 0
         matrix.M33 = 1
         matrix.M34 = 0
         matrix.M41 = 0
         matrix.M42 = 0
         matrix.M43 = 0
         matrix.M44 = 1
		 Return matrix
	End Function
	
	Function CreateRotationZRef(radians:Float, matrix:TMatrix) 
		Local num2:Float = Cos(MathHelper.ToDegrees(radians)) 
		Local num:Float = Sin(MathHelper.ToDegrees(radians)) 
		matrix.M11 = num2
		matrix.M12 = num
		matrix.M13 = 0
		matrix.M14 = 0
		matrix.M21 = -num
		matrix.M22 = num2
		matrix.M23 = 0
		matrix.M24 = 0
		matrix.M31 = 0
		matrix.M32 = 0
		matrix.M33 = 1
		matrix.M34 = 0
		matrix.M41 = 0
		matrix.M42 = 0
		matrix.M43 = 0
		matrix.M44 = 1
	End Function
	
	Function CreateTranslation(xPosition:Float, yPosition:Float, zPosition:Float, result:TMatrix) 
		result.M11 = 1
		result.M12 = 0
		result.M13 = 0
		result.M14 = 0
		result.M21 = 0
		result.M22 = 1
		result.M23 = 0
		result.M24 = 0
		result.M31 = 0
		result.M32 = 0
		result.M33 = 1
		result.M34 = 0
		result.M41 = xPosition
		result.M42 = yPosition
		result.M43 = zPosition
		result.M44 = 1
	End Function
'#End Region 

'#Region invert
	Function InvertRef(matrix:TMatrix, result:TMatrix) 
		Local num5:Float = matrix.M11
		Local num4:Float = matrix.M12
		Local num3:Float = matrix.M13
		Local num2:Float = matrix.M14
		Local num9:Float = matrix.M21
		Local num8:Float = matrix.M22
		Local num7:Float = matrix.M23
		Local num6:Float = matrix.M24
		Local num17:Float = matrix.M31
		Local num16:Float = matrix.M32
		Local num15:Float = matrix.M33
		Local num14:Float = matrix.M34
		Local num13:Float = matrix.M41
		Local num12:Float = matrix.M42
		Local num11:Float = matrix.M43
		Local num10:Float = matrix.M44
		Local num23:Float = (num15 * num10) - (num14 * num11)
		Local num22:Float = (num16 * num10) - (num14 * num12)
		Local num21:Float = (num16 * num11) - (num15 * num12)
		Local num20:Float = (num17 * num10) - (num14 * num13)
		Local num19:Float = (num17 * num11) - (num15 * num13)
		Local num18:Float = (num17 * num12) - (num16 * num13)
		Local num39:Float = ((num8 * num23) - (num7 * num22)) + (num6 * num21)
		Local num38:Float = -(((num9 * num23) - (num7 * num20)) + (num6 * num19))
		Local num37:Float = ((num9 * num22) - (num8 * num20)) + (num6 * num18)
		Local num36:Float = -(((num9 * num21) - (num8 * num19)) + (num7 * num18))
		Local num:Float = 1.0 / ((((num5 * num39) + (num4 * num38)) + (num3 * num37)) + (num2 * num36)) 
		result.M11 = num39 * num
		result.M21 = num38 * num
		result.M31 = num37 * num
		result.M41 = num36 * num
		result.M12 = -(((num4 * num23) - (num3 * num22)) + (num2 * num21)) * num
		result.M22 = (((num5 * num23) - (num3 * num20)) + (num2 * num19)) * num
		result.M32 = -(((num5 * num22) - (num4 * num20)) + (num2 * num18)) * num
		result.M42 = (((num5 * num21) - (num4 * num19)) + (num3 * num18)) * num
		Local num35:Float = (num7 * num10) - (num6 * num11) 
		Local num34:Float = (num8 * num10) - (num6 * num12)
		Local num33:Float = (num8 * num11) - (num7 * num12)
		Local num32:Float = (num9 * num10) - (num6 * num13)
		Local num31:Float = (num9 * num11) - (num7 * num13)
		Local num30:Float = (num9 * num12) - (num8 * num13)
		result.M13 = (((num4 * num35) - (num3 * num34)) + (num2 * num33)) * num
		result.M23 = -(((num5 * num35) - (num3 * num32)) + (num2 * num31)) * num
		result.M33 = (((num5 * num34) - (num4 * num32)) + (num2 * num30)) * num
		result.M43 = -(((num5 * num33) - (num4 * num31)) + (num3 * num30)) * num
		Local num29:Float = (num7 * num14) - (num6 * num15) 
		Local num28:Float = (num8 * num14) - (num6 * num16)
		Local num27:Float = (num8 * num15) - (num7 * num16)
		Local num26:Float = (num9 * num14) - (num6 * num17)
		Local num25:Float = (num9 * num15) - (num7 * num17)
		Local num24:Float = (num9 * num16) - (num8 * num17)
		result.M14 = -(((num4 * num29) - (num3 * num28)) + (num2 * num27)) * num
		result.M24 = (((num5 * num29) - (num3 * num26)) + (num2 * num25)) * num
		result.M34 = -(((num5 * num28) - (num4 * num26)) + (num2 * num24)) * num
		result.M44 = (((num5 * num27) - (num4 * num25)) + (num3 * num24)) * num
	End Function
	
	Function Invert:TMatrix(matrix:TMatrix) 
		Local matrix2:TMatrix = New TMatrix
		Local num5:Float = matrix.M11
		Local num4:Float = matrix.M12
		Local num3:Float = matrix.M13
		Local num2:Float = matrix.M14
		Local num9:Float = matrix.M21
		Local num8:Float = matrix.M22
		Local num7:Float = matrix.M23
		Local num6:Float = matrix.M24
		Local num17:Float = matrix.M31
		Local num16:Float = matrix.M32
		Local num15:Float = matrix.M33
		Local num14:Float = matrix.M34
		Local num13:Float = matrix.M41
		Local num12:Float = matrix.M42
		Local num11:Float = matrix.M43
		Local num10:Float = matrix.M44
		Local num23:Float = (num15 * num10) - (num14 * num11) 
		Local num22:Float = (num16 * num10) - (num14 * num12) 
		Local num21:Float = (num16 * num11) - (num15 * num12) 
		Local num20:Float = (num17 * num10) - (num14 * num13) 
		Local num19:Float = (num17 * num11) - (num15 * num13) 
		Local num18:Float = (num17 * num12) - (num16 * num13) 
		Local num39:Float = ((num8 * num23) - (num7 * num22)) + (num6 * num21) 
		Local num38:Float = -(((num9 * num23) - (num7 * num20)) + (num6 * num19)) 
		Local num37:Float = ((num9 * num22) - (num8 * num20)) + (num6 * num18) 
		Local num36:Float = -(((num9 * num21) - (num8 * num19)) + (num7 * num18)) 
		Local num:Float = 1.0 / ((((num5 * num39) + (num4 * num38)) + (num3 * num37)) + (num2 * num36)) 
		matrix2.M11 = num39 * num
		matrix2.M21 = num38 * num
		matrix2.M31 = num37 * num
		matrix2.M41 = num36 * num
		matrix2.M12 = -(((num4 * num23) - (num3 * num22)) + (num2 * num21)) * num
		matrix2.M22 = (((num5 * num23) - (num3 * num20)) + (num2 * num19)) * num
		matrix2.M32 = -(((num5 * num22) - (num4 * num20)) + (num2 * num18)) * num
		matrix2.M42 = (((num5 * num21) - (num4 * num19)) + (num3 * num18)) * num
		Local num35:Float = (num7 * num10) - (num6 * num11) 
		Local num34:Float = (num8 * num10) - (num6 * num12) 
		Local num33:Float = (num8 * num11) - (num7 * num12) 
		Local num32:Float = (num9 * num10) - (num6 * num13) 
		Local num31:Float = (num9 * num11) - (num7 * num13) 
		Local num30:Float = (num9 * num12) - (num8 * num13) 
		matrix2.M13 = (((num4 * num35) - (num3 * num34)) + (num2 * num33)) * num
		matrix2.M23 = -(((num5 * num35) - (num3 * num32)) + (num2 * num31)) * num
		matrix2.M33 = (((num5 * num34) - (num4 * num32)) + (num2 * num30)) * num
		matrix2.M43 = -(((num5 * num33) - (num4 * num31)) + (num3 * num30)) * num
		Local num29:Float = (num7 * num14) - (num6 * num15) 
		Local num28:Float = (num8 * num14) - (num6 * num16) 
		Local num27:Float = (num8 * num15) - (num7 * num16) 
		Local num26:Float = (num9 * num14) - (num6 * num17) 
		Local num25:Float = (num9 * num15) - (num7 * num17) 
		Local num24:Float = (num9 * num16) - (num8 * num17) 
		matrix2.M14 = -(((num4 * num29) - (num3 * num28)) + (num2 * num27)) * num
		matrix2.M24 = (((num5 * num29) - (num3 * num26)) + (num2 * num25)) * num
		matrix2.M34 = -(((num5 * num28) - (num4 * num26)) + (num2 * num24)) * num
		matrix2.M44 = (((num5 * num27) - (num4 * num25)) + (num3 * num24)) * num
		Return matrix2
	End Function
'#End Region 
	
'#Region Transpose
	Function Transpose(matrix:TMatrix, result:TMatrix) 
		Local num16:Float = matrix.M11
		Local num15:Float = matrix.M12
		Local num14:Float = matrix.M13
		Local num13:Float = matrix.M14
		Local num12:Float = matrix.M21
		Local num11:Float = matrix.M22
		Local num10:Float = matrix.M23
		Local num9:Float = matrix.M24
		Local num8:Float = matrix.M31
		Local num7:Float = matrix.M32
		Local num6:Float = matrix.M33
		Local num5:Float = matrix.M34
		Local num4:Float = matrix.M41
		Local num3:Float = matrix.M42
		Local num2:Float = matrix.M43
		Local num:Float = matrix.M44
		result.M11 = num16
		result.M12 = num12
		result.M13 = num8
		result.M14 = num4
		result.M21 = num15
		result.M22 = num11
		result.M23 = num7
		result.M24 = num3
		result.M31 = num14
		result.M32 = num10
		result.M33 = num6
		result.M34 = num2
		result.M41 = num13
		result.M42 = num9
		result.M43 = num5
		result.M44 = num
	End Function
'#End Region 
	
'#Region Multiply
	Function Multiply(matrix1:TMatrix, matrix2:TMatrix, result:TMatrix) 
		Local num16:Float = (((matrix1.M11 * matrix2.M11) + (matrix1.M12 * matrix2.M21)) + (matrix1.M13 * matrix2.M31)) + (matrix1.M14 * matrix2.M41) 
		Local num15:Float = (((matrix1.M11 * matrix2.M12) + (matrix1.M12 * matrix2.M22)) + (matrix1.M13 * matrix2.M32)) + (matrix1.M14 * matrix2.M42) 
		Local num14:Float = (((matrix1.M11 * matrix2.M13) + (matrix1.M12 * matrix2.M23)) + (matrix1.M13 * matrix2.M33)) + (matrix1.M14 * matrix2.M43)
		Local num13:Float = (((matrix1.M11 * matrix2.M14) + (matrix1.M12 * matrix2.M24)) + (matrix1.M13 * matrix2.M34)) + (matrix1.M14 * matrix2.M44)
		Local num12:Float = (((matrix1.M21 * matrix2.M11) + (matrix1.M22 * matrix2.M21)) + (matrix1.M23 * matrix2.M31)) + (matrix1.M24 * matrix2.M41)
		Local num11:Float = (((matrix1.M21 * matrix2.M12) + (matrix1.M22 * matrix2.M22)) + (matrix1.M23 * matrix2.M32)) + (matrix1.M24 * matrix2.M42)
		Local num10:Float = (((matrix1.M21 * matrix2.M13) + (matrix1.M22 * matrix2.M23)) + (matrix1.M23 * matrix2.M33)) + (matrix1.M24 * matrix2.M43)
		Local num9:Float = (((matrix1.M21 * matrix2.M14) + (matrix1.M22 * matrix2.M24)) + (matrix1.M23 * matrix2.M34)) + (matrix1.M24 * matrix2.M44)
		Local num8:Float = (((matrix1.M31 * matrix2.M11) + (matrix1.M32 * matrix2.M21)) + (matrix1.M33 * matrix2.M31)) + (matrix1.M34 * matrix2.M41)
		Local num7:Float = (((matrix1.M31 * matrix2.M12) + (matrix1.M32 * matrix2.M22)) + (matrix1.M33 * matrix2.M32)) + (matrix1.M34 * matrix2.M42)
		Local num6:Float = (((matrix1.M31 * matrix2.M13) + (matrix1.M32 * matrix2.M23)) + (matrix1.M33 * matrix2.M33)) + (matrix1.M34 * matrix2.M43)
		Local num5:Float = (((matrix1.M31 * matrix2.M14) + (matrix1.M32 * matrix2.M24)) + (matrix1.M33 * matrix2.M34)) + (matrix1.M34 * matrix2.M44)
		Local num4:Float = (((matrix1.M41 * matrix2.M11) + (matrix1.M42 * matrix2.M21)) + (matrix1.M43 * matrix2.M31)) + (matrix1.M44 * matrix2.M41)
		Local num3:Float = (((matrix1.M41 * matrix2.M12) + (matrix1.M42 * matrix2.M22)) + (matrix1.M43 * matrix2.M32)) + (matrix1.M44 * matrix2.M42)
		Local num2:Float = (((matrix1.M41 * matrix2.M13) + (matrix1.M42 * matrix2.M23)) + (matrix1.M43 * matrix2.M33)) + (matrix1.M44 * matrix2.M43)
		Local num:Float = (((matrix1.M41 * matrix2.M14) + (matrix1.M42 * matrix2.M24)) + (matrix1.M43 * matrix2.M34)) + (matrix1.M44 * matrix2.M44)
		result.M11 = num16
		result.M12 = num15
		result.M13 = num14
		result.M14 = num13
		result.M21 = num12
		result.M22 = num11
		result.M23 = num10
		result.M24 = num9
		result.M31 = num8
		result.M32 = num7
		result.M33 = num6
		result.M34 = num5
		result.M41 = num4
		result.M42 = num3
		result.M43 = num2
		result.M44 = num
	End Function
'#End Region 
	
'#Region Add
	Function AddRef(matrix1:TMatrix, matrix2:TMatrix, result:TMatrix) 
		result.M11 = matrix1.M11 + matrix2.M11
		result.M12 = matrix1.M12 + matrix2.M12
		result.M13 = matrix1.M13 + matrix2.M13
		result.M14 = matrix1.M14 + matrix2.M14
		result.M21 = matrix1.M21 + matrix2.M21
		result.M22 = matrix1.M22 + matrix2.M22
		result.M23 = matrix1.M23 + matrix2.M23
		result.M24 = matrix1.M24 + matrix2.M24
		result.M31 = matrix1.M31 + matrix2.M31
		result.M32 = matrix1.M32 + matrix2.M32
		result.M33 = matrix1.M33 + matrix2.M33
		result.M34 = matrix1.M34 + matrix2.M34
		result.M41 = matrix1.M41 + matrix2.M41
		result.M42 = matrix1.M42 + matrix2.M42
		result.M43 = matrix1.M43 + matrix2.M43
		result.M44 = matrix1.M44 + matrix2.M44
	End Function
'#End Region 
	
	Method GetRight:Vector3() 
		Local vector:Vector3 = New Vector3
		vector.X = Self.M11
		vector.Y = Self.M12
		vector.Z = Self.M13
	End Method
	
	Method SetRight(value:Vector3) 
		M11 = value.X
		M12 = value.Y
		M13 = value.Z
	End Method
	
	
	Method GetUp:Vector3() 
		Local vector:Vector3 = New Vector3
		vector.X = M21
		vector.Y = M22
		vector.Z = M23
	End Method
	
	Method SetUp(value:Vector3) 
		M21 = value.X
		M22 = value.Y
		M23 = value.Z
	End Method
	
	Function Identity:TMatrix() 
		Return _identity.Copy() 
	End Function
	
	Method Copy:TMatrix() 
		Return Create(M11, M12, M13, M14, M21, M22, M23, M24, M31, M32, M33, M34, M41, M42, M43, M44) 
	End Method
	
	Method CopyTo(result:TMatrix)
		result.M11 = M11
		result.M12 = M12
		result.M13 = M13
		result.M14 = M14
		result.M21 = M21
		result.M22 = M22
		result.M23 = M23
		result.M24 = M24
		result.M31 = M31
		result.M32 = M32
		result.M33 = M33
		result.M34 = M34
		result.M41 = M41
		result.M42 = M42
		result.M43 = M43
		result.M44 = M44
	End Method
	Method ToString:String()
		Local str:String = "| " + M11 + " " + M12 + " " + M13 + " " + M14 + " |~n"
		str:+"| " + M21 + " " + M22 + " " + M23 + " " + M24 + " |~n"
		str:+"| " + M31 + " " + M32 + " " + M33 + " " + M34 + " |~n"
		str:+"| " + M41 + " " + M42 + " " + M43 + " " + M44 + " |~n"
		str:+"~n"
		Return str
	End Method
End Type
