
Type MathHelper
	Const DegreesToRadiansRatio:Float = 57.29577957855
	Const RadiansToDegreesratio:Float = 1 / 57.29577957855
	
	Const TwoPi:Float = Pi * 2
	Const PiOver2:Float = Pi / 2
	Const PiOver4:Float = Pi / 4
	Const MaxValueF:Float = 3.40282e38
	Const MinValueF:Float = 10 ^ -38
	Const MaxValueInt:Int = 2147483647
	Const MinValueInt:Int = -2147483648
	Const PositiveInfinityF:Float = 1.0 / 0.0
	
	Function Lerp:Float(value1:Float, value2:Float, amount:Float)
		Return value1 + (value2 - value1) * amount
	End Function
	
		rem
	bbdoc: interpolates the start/end position using a sigmoid curve ("S" shape)
	end rem
	Function SmoothStep:Float(startVal:Float, endval:Float, blend:Float) 
		Local alpha:Float = (blend * blend) * (3 - blend * 2) 
		Return Lerp(startVal, endval, alpha) 
	End Function
	
	Function Clamp:Float(value:Float, minVal:Float, maxVal:Float) 
		Return Max(minval, Min(value, maxVal)) 
	End Function
	
	Function Distance:Float(value1:Float, value2:Float) 
		Return Abs(value2 - value1) 
	End Function
	
	Function ToRadians:Float(degrees:Float) 
		Return degrees * RadiansToDegreesRatio
	End Function
	
	Function ToDegrees:Float(radians:Float) 
		Return radians * DegreesToRadiansRatio
	End Function
	
End Type
