
Type TRevoluteJoint Extends TJoint

	Field _body1:TBody
	Field _body2:TBody
	
	Field _biasFactor:Float =.2
	Field _softness:Float
	Field _breakpoint:Float = MathHelper.MaxValueF
	
	Field _jointError:Float
	Field _matrix:TMatrix = TMatrix.Identity()
	Field _anchor:Vector2 = Vector2.Zero()
	Field _localAnchor1:Vector2 = Vector2.Zero()
	Field _localAnchor2:Vector2 = Vector2.Zero()
	Field _r1:Vector2 = Vector2.Zero()
	Field _r2:Vector2 = Vector2.Zero()
	Field _velocityBias:Vector2 = Vector2.Zero()
	Field _accumulatedImpulse:Vector2 = Vector2.Zero()
	Field _currentAnchor:Vector2 = Vector2.Zero()
	
	Method GetBody1:TBody()
		Return _body1
	End Method
	
	Method SetBody1(value:TBody)
		_body1 = value
	End Method
	
	Method GetBody2:TBody()
		Return _body2
	End Method
	
	Method SetBody2(value:TBody)
		_body2 = value
	End Method
	
	Method GetBiasFactor:Float()
		Return _biasFactor
	End Method
	
	Method SetBiasFactor(value:Float)
		_biasFactor = value
	End Method
	
	Method GetSoftness:Float()
		Return _softness
	End Method
	
	Method SetSoftness(value:Float)
		_softness = value
	End Method
	
	Method GetBreakPoint:Float()
		Return _breakpoint
	End Method
	
	Method SetBreakPoint(value:Float)
		_breakpoint = value
	End Method
	
	Method GetJointError:Float()
		Return _jointError
	End Method
	
	Method SetAnchor(value:Vector2)
		_anchor.X = value.X
		_anchor.Y = value.Y
		_body1.GetLocalPositionRef(_anchor, _localAnchor1)
		_body2.GetLocalPositionRef(_anchor, _localAnchor2)
	End Method
	
	Method GetAnchor:Vector2()
		Return _anchor.Copy()
	End Method
	
	' this gives anchor position after sim starts
	Method GetCurrentAnchor:Vector2()
		Vector2.AddVectorsRef(_body1._position, _r1, _currentAnchor)
		Return _currentAnchor.Copy()
	End Method
	
	Method SetInitialAnchor(initialAnchor:Vector2)
		_anchor.X = initialAnchor.X
		_anchor.Y = initialAnchor.Y
		If _body1 = Null Then Throw "Body must be set prior to setting the anchor of the Revolute Joint"
		_body1.GetLocalPositionRef(_anchor, _localAnchor1)
		_body2.GetLocalPositionRef(_anchor, _localAnchor2)
	End Method
	
	Function Create:TRevoluteJoint(body1:TBody, body2:TBody, anchor:Vector2)
		Local joint:TRevoluteJoint = New TRevoluteJoint
		joint._body1 = body1
		joint._body2 = body2
		joint._anchor.X = anchor.X
		joint._anchor.Y = anchor.Y
		
		body1.GetLocalPositionRef(anchor, joint._localAnchor1)
		body2.GetLocalPositionRef(anchor, joint._localAnchor2)
		
		joint._accumulatedImpulse.X = 0
		joint._accumulatedImpulse.Y = 0
		Return joint
	End Function
	
	'#Region PreStep variables
	Field _floatTemp1:Float = 0
	Field _vectorTemp1:Vector2 = Vector2.Zero()
	Field _vectorTemp2:Vector2 = Vector2.Zero()
	Field _vectorTemp3:Vector2 = Vector2.Zero()
	Field _vectorTemp4:Vector2 = Vector2.Zero()
	Field _vectorTemp5:Vector2 = Vector2.Zero()
	
	Field _K:TMatrix = TMatrix.Identity()
	Field _K1:TMatrix = TMatrix.Identity()
	Field _K2:TMatrix = TMatrix.Identity()
	Field _K3:TMatrix = TMatrix.Identity()
	
	Field _body1MatrixTemp:TMatrix = TMatrix.Identity()
	Field _body1InverseMass:Float
	Field _body1InverseMomentOfInertia:Float
	
	Field _body2MatrixTemp:TMatrix = TMatrix.Identity()
	Field _body2InverseMass:Float
	Field _body2InverseMomentOfInertia:Float	
	'#End Region 
	Method PreStep(inversedt:Float)
		If Abs(_jointError) > _breakPoint Then Return
		
		_body1InverseMass = _body1._inverseMass
		_body1InverseMomentOfInertia = _body1._inverseMomentOfInertia
		
		_body2InverseMass = _body2._inverseMass
		_body2InverseMomentOfInertia = _body2._inverseMomentOfInertia
		
		_body1.GetBodyMatrixRef(_body1MatrixTemp)
		_body2.GetBodyMatrixRef(_body2MatrixTemp)
		Vector2.TransformNormalRef(_localAnchor1, _body1MatrixTemp, _r1)
		Vector2.TransformNormalRef(_localAnchor2, _body2MatrixTemp, _r2)
		
		_K1.M11 = _body1InverseMass + _body2InverseMass
		_K1.M12 = 0
		_K1.M21 = 0
		_K1.M22 = _body1InverseMass + _body2InverseMass
		
		_K2.M11 = _body1InverseMomentOfInertia * _r1.Y * _r1.Y
		_K2.M12 = -_body1InverseMomentOfInertia * _r1.X * _r1.Y
		_K2.M21 = -_body1InverseMomentOfInertia * _r1.X * _r1.Y
		_K2.M22 = _body1InverseMomentOfInertia * _r1.X * _r1.X
		
		_K3.M11 = _body2InverseMomentOfInertia * _r2.Y * _r2.Y
		_K3.M12 = -_body2InverseMomentOfInertia * _r2.X * _r2.Y
		_K3.M21 = -_body2InverseMomentOfInertia * _r2.X * _r2.Y
		_K3.M22 = _body2InverseMomentOfInertia * _r2.X * _r2.X
		
		'matrix K = K1 + k2 + k3
		TMatrix.AddRef(_K1, _K2, _K)
		TMatrix.AddRef(_K, _K3, _K)
		
		_K.M11:+_softness
		_K.M12:+_softness
		
		' matrix = matrixInvert2D(K)
		MatrixInvert2D(_K, _matrix)
		
		Vector2.AddVectorsRef(_body1._position, _r1, _vectorTemp1)
		Vector2.AddVectorsRef(_body2._position, _r2, _vectorTemp2)
		Vector2.SubtractVectorsRef(_vectorTemp2, _vectorTemp1, _vectorTemp3)
		Vector2.ScaleRef(_vectorTemp3, - _biasFactor * inverseDt, _velocityBias)
		
		_jointError = _vectorTemp3.Length()
		
		_body2.ApplyImmediateImpulse(_accumulatedImpulse)
		_floatTemp1 = Calculator.CrossVV(_r2, _accumulatedImpulse)
		_body2.ApplyAngularImpulse(_floatTemp1)
		
		Vector2.ScaleRef(_accumulatedImpulse, - 1, _vectorTemp1)
		_body1.ApplyImmediateImpulse(_vectorTemp1)
		_floatTemp1 = Calculator.CrossVV(_r1, _accumulatedIMpulse)
		_body1.ApplyAngularImpulse(- _floatTemp1)
		
	End Method
	
	Field _B:TMatrix = TMatrix.Identity()
	Method MatrixInvert2D(matrix:TMatrix, outInvertedMatrix:TMatrix)
		Local a:Float = matrix.M11
		Local b:Float = matrix.M12
		Local c:Float = matrix.M21
		Local d:Float = matrix.M22
		Local det:Float = a * d - b * c
		Assert det <> 0, "Determinant is equal to Zero in revolute Joint"
		det = 1.0 / det
		_B.M11 = det * d; _B.M12 = -det * b
		_B.M21 = -det * c; _B.M22 = det * a
		_B.CopyTo(outInvertedMatrix)
	End Method
	
	Field _dv:Vector2 = Vector2.Zero()
	Field _dvBias:Vector2 = Vector2.Zero()
	Field _impulse:Vector2 = Vector2.Zero()
	Method Update()
		If Abs(_jointError) > _breakpoint Then Return
		
		'#region INLINE:Calculator.Cross(ref body2.angularVelocity, ref r2, out vectorTemp1) 
		_vectorTemp1.X = -_body2._angularVelocity * _r2.Y
		_vectorTemp1.Y = _body2._angularVelocity * _r2.X
		'#endregion
		
		'#region INLINE:Calculator.Cross(ref body1.angularVelocity, ref r1, out vectorTemp2) 
		_vectorTemp2.X = -_body1._angularVelocity * _r1.Y
		_vectorTemp2.Y = _body1._angularVelocity * _r1.X
		'#endregion
		
		'#region INLINE:Vector2.add(ref body2.linearVelocity, ref vectorTemp1, out vectorTemp3) 
		_vectorTemp3.X = _body2._linearVelocity.X + _vectorTemp1.X
		_vectorTemp3.Y = _body2._linearVelocity.Y + _vectorTemp1.Y
		'#endregion
		
		'#region INLINE:Vector2.add(ref body1.linearVelocity, ref vectorTemp2, out vectorTemp4) 
		_vectorTemp4.X = _body1._linearVelocity.X + _vectorTemp2.X
		_vectorTemp4.Y = _body1._linearVelocity.Y + _vectorTemp2.Y
		'#endregion
		
		'#region INLINE:Vector2.Subtract(ref vectorTemp3, ref vectorTemp4, out dv) 
		_dv.X = _vectorTemp3.X - _vectorTemp4.X
		_dv.Y = _vectorTemp3.Y - _vectorTemp4.Y
		'#endregion
		
		'#region INLINE:Vector2.Subtract(ref velocityBias, ref dv, out vectorTemp1) 
		_vectorTemp1.X = _velocityBias.X - _dv.X
		_vectorTemp1.Y = _velocityBias.Y - _dv.Y
		'#endregion
		
		'#region INLINE:Vector2.Multiply(ref accumulatedImpulse, softness, out vectorTemp2) 
		_vectorTemp2.X = _accumulatedImpulse.X * _softness
		_vectorTemp2.Y = _accumulatedImpulse.Y * _softness
		'#endregion
		
		'#region INLINE:Vector2.Subtract(ref vectorTemp1, ref vectorTemp2, out dvBias) 
		_dvBias.X = _vectorTemp1.X - _vectorTemp2.X
		_dvBias.Y = _vectorTemp1.Y - _vectorTemp2.Y
		'#endregion
		
		'#region INLINE:Vector2.Transform(ref dvBias, ref _matrix, out impulse) 
		Local num2:Float = ((_dvBias.X * _matrix.M11) + (_dvBias.Y * _matrix.M21)) + _matrix.M41
		Local num:Float = ((_dvBias.X * _matrix.M12) + (_dvBias.Y * _matrix.M22)) + _matrix.M42
		_impulse.X = num2
		_impulse.Y = num
		'#endregion
		
		'#region INLINE:body2.ApplyImpulse(ref impulse) 
		_dv.X = _impulse.X * _body2._inverseMass
		_dv.Y = _impulse.Y * _body2._inverseMass
		
		_body2._linearVelocity.X = _dv.X + _body2._linearVelocity.X
		_body2._linearVelocity.Y = _dv.Y + _body2._linearVelocity.Y
		'#endregion
		
		'#region INLINE:Calculator.Cross(ref r2, ref impulse, out floatTemp1) 
		_floatTemp1 = _r2.X * _impulse.Y - _r2.Y * _impulse.X
		'#endregion
		
		'#region INLINE:body2.ApplyAngularImpulse(ref floatTemp1) 
		_body2._angularVelocity:+_floatTemp1 * _body2._inverseMomentOfInertia
		'#endregion
		
		'#region INLINE:Vector2.Multiply(ref impulse, - 1, out vectorTemp1) 
		_vectorTemp1.X = _impulse.X * -1
		_vectorTemp1.Y = _impulse.Y * -1
		'#endregion
		
		'#region INLINE:body1.ApplyImpulse(ref vectorTemp1) 
		_dv.X = _vectorTemp1.X * _body1._inverseMass
		_dv.Y = _vectorTemp1.Y * _body1._inverseMass
		
		_body1._linearVelocity.X = _dv.X + _body1._linearVelocity.X
		_body1._linearVelocity.Y = _dv.Y + _body1._linearVelocity.Y
		'#endregion
		
		'#region INLINE:Calculator.Cross(ref r1, ref impulse, out floatTemp1) 
		_floatTemp1 = _r1.X * _impulse.Y - _r1.Y * _impulse.X
		'#endregion
		
		_floatTemp1 = -_floatTemp1
		'#region INLINE:body1.ApplyAngularImpulse(ref floatTemp1) 
		_body1._angularVelocity:+_floatTemp1 * _body1._inverseMomentOfInertia
		'#endregion
		
		'#region INLINE:Vector2.add(ref accumulatedImpulse, ref impulse, out accumulatedImpulse) 
		_accumulatedImpulse.X = _accumulatedImpulse.X + _impulse.X
		_accumulatedImpulse.Y = _accumulatedImpulse.Y + _impulse.Y
		'#endregion
	End Method
	
End Type
