
Type TLinearSpring extends TController

	Field _body1:TBody
	Field _body2:TBody
	Field _attachPoint1:Vector2 = Vector2.Zero()
	Field _attachPoint2:Vector2 = Vector2.Zero()
	
	Field _springConstant:Float
	Field _dampningConstant:Float
	Field _restLength:Float
	Field _breakpoint:Float = MathHelper.MaxValueF
	
	Field _springError:Float
	Field _difference:Vector2 = Vector2.Zero()
	
	
	Method GetBody1:TBody()
		Return _body1
	End Method
	
	Method SetBody1(value:TBody)
		_body1 = value
	End Method
	
	Method GetBody2:TBody()
		Return _body2
	End Method
	
	Method SetBody2(value:TBody)
		_body2 = value
	End Method
	
	Method GetAttachPoint1:Vector2()
		Return _attachPoint1.Copy()
	End Method
	
	Method SetAttachPoint1(value:Vector2)
		_attachPoint1.X = value.X
		_attachPoint1.Y = value.Y
	End Method
	
	Method GetAttachPoint2:Vector2()
		Return _attachPoint2.Copy()
	End Method
	
	Method SetAttachPoint2(value:Vector2)
		_attachPoint2.X = value.X
		_attachPoint2.Y = value.Y
	End Method
	
		Method GetSpringConstant:Float()
		Return _springConstant
	End Method
	
	Method SetSpringConstant(value:Float)
		_springConstant = value
	End Method
	
	Method GetDampningConstant:Float()
		Return _dampningConstant
	End Method
	
	Method SetDampningConstant(value:Float)
		_dampningConstant = value
	End Method
	
	Method GetBreakPoint:Float()
		Return _breakpoint
	End Method
	
	Method SetBreakPoint(value:Float)
		_breakpoint = value
	End Method
	
	Method GetSpringError:Float()
		Return _springError
	End Method
	
		Method GetRestLength:Float()
		Return _restLength
	End Method
	
	Method SetRestLength(value:Float)
		_restLength = value
	End Method
	
	Function Create:TLinearSpring(body1:TBody, attachPoint1:Vector2, body2:TBody, attachPoint2:Vector2, springConstant:Float, dampningConstant:Float)
		Local spring:TLinearSpring = New TLinearSpring
		spring._body1 = body1
		spring._body2 = body2
		spring._attachPoint1.X = attachPoint1.X
		spring._attachPoint1.Y = attachPoint1.Y
		spring._attachPoint2.X = attachPoint2.X
		spring._attachPoint2.Y = attachPoint2.Y
		spring._dampningConstant = dampningConstant
		Vector2.SubtractVectorsRef(body2.GetWorldPosition(attachPoint2), body1.GetWorldPosition(attachPoint1), spring._difference)
		spring._restLength = spring._difference.Length()
		spring._springConstant = springConstant
		Return spring
	End Function
	
	Field _force:Vector2 = Vector2.Zero()
	Field _worldPoint1:Vector2 = Vector2.Zero()
	Field _worldPoint2:Vector2 = Vector2.Zero()
	Field _velocityAtPoint1:Vector2 = Vector2.Zero()
	Field _velocityAtPoint2:Vector2 = Vector2.Zero()
	Field _relativeVelocity:Vector2 = Vector2.Zero()
	Field _differenceNormalized:Vector2 = Vector2.Zero()
	Field _vectorTemp2:Vector2 = Vector2.Zero()
	Field _dampningForce:Float
	Field _springForce:Float
	Field _epsilon:Float = 0.00001
	Field _temp:Float
	Method Update(dt:Float)
		If Abs(_springerror) > _breakpoint Then Return
		
		' calculate and apply spring force
		' F= -{s(L-r) + d[(v1-v2).L]/l/L/1 : s=spring const, d= dampning const, L=difference vector(p1-p2), l = difference magnitude, r= rest length
		_body1.GetWorldPositionRef(_attachPoint1, _worldPoint1)
		_body2.GetWorldPositionRef(_attachPoint2, _worldPoint2)
		Vector2.SubtractVectorsRef(_worldPoint1, _worldPoint2, _difference)
		Local differenceMagnitude:Float = _difference.Length()
		If differenceMagnitude < _epsilon Then Return
		
		' calculate spring force
		_springError = differenceMagnitude - _restLength
		Vector2.NormalizeRef(_difference, _differenceNormalized)
		_springForce = _springConstant * _springError 'kX
		
		' calculate relative velocity
		_body1.GetVelocityAtLocalPointRef(_attachPoint1, _velocityAtPoint1)
		_body2.GetVelocityAtLocalPointRef(_attachPoint2, _velocityAtPoint2)
		Vector2.SubtractVectorsRef(_velocityAtPoint1, _velocityAtPoint2, _relativeVelocity)
		
		'calculate dampning force
		_temp = Vector2.Dot(_relativeVelocity, _difference)
		_dampningForce = _dampningConstant * _temp / differenceMagnitude 'bV
		
		'calculate final force (spring+dampning)
		Vector2.ScaleRef(_differenceNormalized, - (_springForce + _dampningForce), _force)
		If Not _body1._isStatic Then
			_body1.ApplyForceAtLocalPoint(_force, _attachPoint1)
		End If
		
		If Not _body2._isStatic Then
			_force.X = _force.X * -1
			_force.Y = _force.Y * -1
			_body2.ApplyForceAtLocalPoint(_force, _attachPoint2)
		End If
	End Method

End Type
