
Type TJointFactory

	' fixed revolute joint
	rem
	bbdoc: create a fixed revolute join.
	physics is optional and if not null
	will add this joint to the physics engine.
	end rem
	Function CreateFixedRevoluteJoint:TFixedRevoluteJoint(physics:TPhysicsSimulator, body:TBody, anchor:Vector2)
		If body.IsStatic() Then Throw "Fixed joints cannot be created on static bodies"
		Local joint:TFixedRevoluteJoint = TFixedRevoluteJoint.Create(body, anchor)
		If physics <> Null Then
			physics.AddJoint(joint)
		End If
		Return joint
	End Function
	
	' revolute joint
	rem
	bbdoc: create a revolute joint
	physics is optional and if not null
	will add this joint to the physics engine.
	end rem
	Function CreateRevoluteJoint:TRevoluteJoint(physics:TPhysicsSimulator, body1:TBody, body2:TBody, initialAnchorPosition:Vector2)
		Local joint:TRevoluteJoint = TRevoluteJoint.Create(body1, body2, initialAnchorPosition)
		If physics <> Null Then
			physics.AddJoint(joint)
		End If
		Return joint
	End Function
	
	' angle joint
	rem
	bbdoc: create an angle joint
	physics is optional and if not null
	will add this joint to the physics engine.
	targetangle is measured in radians
	end rem
	Function CreateAngleJoint:TAngleJoint(physics:TPhysicsSimulator, body1:TBody, body2:TBody, targetAngle:Float = 0)
		Local joint:TAngleJoint = TAngleJoint.Create(body1, body2, targetAngle)
		If physics <> Null Then
			physics.AddJoint(joint)
		End If
		Return joint
	End Function
	
	rem
	bbdoc: create a fixed angle joint.
	physics is optional and if not null
	will add this joint to the physics engine.
	targetangle is measured in radians
	end rem
	Function CreateFixedAngleJoint:TFixedAngleJoint(physics:TPhysicsSimulator, body:TBody, targetAngle:Float)
		Local joint:TFixedAngleJoint = TFixedAngleJoint.Create(body, targetAngle)
		If physics <> Null Then
			physics.AddJoint(joint)
		End If
		Return joint
	End Function
	
	rem
	bbdoc: create an angle limit joint
	physics is optional and if not null
	will add this joint to the physics engine.
	lower/upper limits are measured in radians.
	end rem
	Function CreateAngleLimitJoint:TAngleLimitJoint(physics:TPhysicsSimulator, body1:TBody, body2:TBody, lowerLimit:Float, upperLimit:Float)
		Local joint:TAngleLimitJoint = TAngleLimitJoint.Create(body1, body2, lowerLimit, upperLimit)
		If physics <> Null Then
			physics.AddJoint(joint)
		End If
		Return joint
	End Function
	
	rem
	bbdoc: create a fixed angle limit joint
	physics is optional and if not null
	will add this joint to the physics engine.
	lower/upper limits are measured in radians.
	end rem
	Function CreateFixedAngleLimitJoint:TFixedAngleLimitJoint(physics:TPhysicsSimulator, body:TBody, lowerLimit:Float, upperLimit:Float)
		Local joint:TFixedAngleLimitJoint = TFixedAngleLimitJoint.Create(body, lowerLimit, upperLimit)
		If physics <> Null Then
			physics.AddJoint(joint)
		End If
		Return joint
	End Function	
	
	rem
	bbdoc: create pin joint.
	physics is optional and if not null
	will add this joint to the physics engine.
	anchor1 and anchor2 are in local coordinates for each body.
	end rem
	Function CreatePinJoint:TPinJoint(physics:TPhysicsSimulator, body1:TBody, anchor1:Vector2, body2:TBody, anchor2:Vector2)
		Local joint:TPinJoint = TPinJoint.Create(body1, anchor1, body2, anchor2)
		If physics <> Null Then
			physics.AddJoint(joint)
		End If
		Return joint
	End Function
	
	rem
	bbdoc: create slide joint
	physics is optional and if not null
	will add this joint to the physics engine.
	anchor1 and anchor2 are in local coordinates for each body.
	min/max distance is the distance range these two bodies will keep within.
	end rem
	Function CreateSliderJoint:TSliderJoint(physics:TPhysicsSimulator, body1:TBody, anchor1:Vector2, body2:TBody, anchor2:Vector2, minDistance:Float, maxDistance:Float)
		Local joint:TSliderJoint = TSliderJoint.Create(body1, anchor1, body2, anchor2, minDistance, maxDistance)
		If physics <> Null Then
			physics.AddJoint(joint)
		End If
		Return joint
	End Function
	rem
	bbdoc: create an interactive angle joint
	physics is optional and if not null
	will add this joint to the physics engine.
	angles are measured in radians
	end rem
	Function CreateInteractiveAngleJoint:TInteractiveAngleJoint(physics:TPhysicsSimulator, angle1:Float, angle2:Float, angle3:Float, angle4:Float, angleMin:Float, angleMax:Float, softness:Float, anchor:Vector2, body1:TBody, body2:TBody)
		Local joint:TInteractiveAngleJoint = TInteractiveAngleJoint.Create(angle1, angle2, angle3, angle4, angleMin, angleMax, softness, anchor, body1, body2)
		If physics <> Null Then
			joint.Load(physics)
		End If
		Return joint
	End Function
End Type
