
Type TFixedAngleSpring Extends TController

	'#Region 
	Field _body:TBody
	
	Field _springConstant:Float
	Field _dampningConstant:Float
	Field _targetAngle:Float
	Field _breakpoint:Float = MathHelper.MaxValueF
	Field _maxTorque:Float = MathHelper.MaxValueF
	
	Field _springError:Float
	'#End Region 
	
	'#Region Properties (setter/getter)
	Method GetBody:TBody()
		Return _body
	End Method
	
	Method SetBody(value:TBody)
		_body = value
	End Method
	
	Method GetSpringConstant:Float()
		Return _springConstant
	End Method
	
	Method SetSpringConstant(value:Float)
		_springConstant = value
	End Method
	
	Method GetDampningConstant:Float()
		Return _dampningConstant
	End Method
	
	Method SetDampningConstant(value:Float)
		_dampningConstant = value
	End Method
	
	Method GetTargetAngle:Float()
		Return _targetAngle
	End Method
	
	Method SetTargetAngle(value:Float)
		_targetAngle = value
	End Method
	
	Method GetBreakpoint:Float()
		Return _breakpoint
	End Method
	
	Method SetBreakpoint(value:Float)
		_breakpoint = value
	End Method
	
	Method GetMaxTorque:Float()
		Return _maxTorque
	End Method
	
	Method SetMaxTorque(value:Float)
		_maxTorque = value
	End Method
	
	Method GetSpringError:Float()
		Return _springError
	End Method
	'#End Region 
	
	'#Region Constructor
	Function Create:TFixedAngleSpring(body:TBody, springConstant:Float, dampningConstant:Float)
		Local spring:TFixedAngleSpring = New TFixedAngleSpring
		spring._body = body
		spring._springConstant = springConstant
		spring._dampningConstant = dampningConstant
		spring._targetAngle = body.GetTotalRotation()
		Return spring
	End Function
	'#End Region 
	
	'#Region Public Methods
	Method Update(dt:Float)
		If Abs(_springError) > _breakpoint Then Return
		' calculate and apply spring force
		Local angleDifference:Float = _targetAngle - _body._totalRotation
		Local springTorque:Float = _springConstant * angleDifference
		_springError = angleDifference
		
		' apply torque to anchor
		If Not(_body._isStatic) Then
			Local torque1:Float = springTorque - _dampningConstant * _body._angularVelocity
			torque1 = Min(Abs(torque1), _maxTorque) * Sgn(torque1)
			_body.ApplyTorque(torque1)
		End If
	End Method
	
	'#End Region 
	
End Type
