
Type TFixedAngleLimitJoint Extends TJoint

	Field _body:TBody
	Field _biasFactor:Float =.2
	Field _slop:Float = 0.01
	Field _softness:Float = 0
	Field _upperLimit:Float
	Field _lowerLimit:Float
	Field _breakpoint:Float = MathHelper.MaxValueF
	
	Field _velocityBias:Float
	Field _accumulatedAngularImpulse:Float
	Field _massFactor:Float
	Field _jointError:Float
	Field _upperLimitViolated:Int = False
	Field _lowerLimitViolated:Int = False
	
	Method GetBody:TBody()
		Return _body
	End Method
	
	Method SetBody(value:TBody)
		_body = value
	End Method
	
		Method GetBiasFactor:Float()
		Return _biasFactor
	End Method
	
	Method SetBiasFactor(value:Float)
		_biasFactor = value
	End Method
	
	
	Method GetSlop:Float()
		Return _slop
	End Method
	
	Method SetSlop(value:Float)
		_slop = value
	End Method	
	
	Method GetSoftness:Float()
		Return _softness
	End Method
	
	Method SetSoftness(value:Float)
		_softness = value
	End Method
	
	Method GetUpperLimit:Float()
		Return _upperLimit
	End Method
	
	Method SetUpperLimit(value:Float)
		_upperLimit = value
	End Method
	
	Method GetLowerLimit:Float()
		Return _lowerLimit
	End Method
	
	Method SetLowerLimit(value:Float)
		_lowerLimit = value
	End Method
	
	
	Method GetBreakPoint:Float()
		Return _breakpoint
	End Method
	
	Method SetBreakPoint(value:Float)
		_breakpoint = value
	End Method
	
	Method GetJointError:Float()
		Return _jointError
	End Method
	
	Function Create:TFixedAngleLimitJoint(body:TBody, lowerlimit:Float, upperLimit:Float)
		Local joint:TFixedAngleLimitJoint = New TFixedAngleLimitJoint
		joint._body = body
		joint._lowerLimit = lowerlimit
		joint._upperLimit = upperlimit
		Return joint
	End Function
	
	Field _difference:Float
	Method PreStep(inversedt:Float)
		If Abs(_jointError) > _breakpoint Then
			Return
		End If
		_difference = _body._totalRotation
		
		If _difference > _upperLimit Then
			If _lowerLimitViolated Then
				_accumulatedAngularImpulse = 0
				_lowerLimitViolated = False
			End If
			_upperLimitViolated = True
			If _difference < _upperLimit + _slop Then
				_jointError = 0
			Else
				_jointError = _difference - _upperLimit
			End If
			_velocityBias = _biasFactor * inverseDt * _jointError
			
		Else If _difference < _lowerLimit Then
			If _upperLimitViolated Then
				_accumulatedAngularImpulse = 0
				_upperLimitViolated = False
			End If
			_lowerLimitViolated = True
			If _difference > _lowerLimit - _slop Then
				_jointError = 0
			Else
				_jointError = _difference - _lowerLimit
			End If
		Else
			_upperLimitViolated = False
			_lowerLimitViolated = False
			_jointError = 0
			_accumulatedAngularImpulse = 0
		End If
		_velocityBias = _biasFactor * inverseDt * _jointError
		_massFactor = (1 - _softness) / _body._inverseMomentOfInertia
		_body._angularVelocity:+(_body._inverseMomentOfInertia * _accumulatedAngularImpulse)
	End Method
	
	Field _accumulatedAngularImpulseOld:Float
	Field _angularImpulse:Float
	Method Update()
		If Not(_upperLimitViolated) And Not(_lowerLimitViolated) Then
			Return
		End If
		_angularImpulse = 0
		_angularImpulse = -(_velocityBias + _body._angularVelocity + _softness * _accumulatedAngularImpulse) * _massFactor
		
		_accumulatedAngularImpulseOld = _accumulatedAngularImpulse
		
		If _upperLimitViolated Then
			_accumulatedAngularImpulse = Min(_accumulatedAngularImpulseOld + _angularImpulse, 0)
		Else If _lowerLimitViolated Then
			_accumulatedAngularImpulse = Max(_accumulatedAngularImpulseOld + _angularImpulse, 0)
		End If
		_angularImpulse = _accumulatedAngularImpulse - _accumulatedAngularImpulseOld
		_body._angularVelocity:+_body._inverseMomentOfInertia * _angularImpulse
	End Method
End Type
