
Type TFixedAngleJoint Extends TJoint

	Field _body:TBody
	
	Field _biasFactor:Float =.2
	Field _targetAngle:Float = 0
	Field _softness:Float = 0
	Field _maxImpulse:Float = MathHelper.MaxValueF
	Field _breakpoint:Float = MathHelper.MaxValueF
	
	Field _massFactor:Float
	Field _jointError:Float
	Field _velocityBias:Float
	
	Method GetBody:TBody()
		Return _body
	End Method
	
	Method SetBody(value:TBody)
		_body = value
	End Method

	Method GetBiasFactor:Float()
		Return _biasFactor
	End Method
	
	Method SetBiasFactor(value:Float)
		_biasFactor = value
	End Method
	
	Method GetSoftness:Float()
		Return _softness
	End Method
	
	Method SetSoftness(value:Float)
		_softness = value
	End Method
	
	Method GetBreakPoint:Float()
		Return _breakpoint
	End Method
	
	Method SetBreakPoint(value:Float)
		_breakpoint = value
	End Method
	
	Method GetJointError:Float()
		Return _jointError
	End Method
	
	Method GetTargetAngle:Float()
		Return _targetAngle
	End Method
	
	Method SetTargetAngle(value:Float)
		_targetAngle = value
	End Method
	
	Method GetMaxImpulse:Float()
		Return _maxImpulse
	End Method
	
	Method SetMaxImpulse(value:Float)
		_maxImpulse = value
	End Method
	
	Function Create:TFixedAngleJoint(body:TBody, targetAngle:Float)
		Local joint:TFixedAngleJoint = New TFixedAngleJoint
		joint._body = body
		joint._targetAngle = targetAngle
		Return joint
	End Function
	
	
	Method PreStep(inversedt:Float)
		If Abs(_jointError) > _breakpoint Then Return
		_jointError = _body._totalRotation - _targetAngle
		
		_velocityBias = -_biasFactor * inverseDt * _jointError
		_massFactor = (1 - _softness) / (_body._inverseMomentOfInertia)		
	End Method
	
	Method Update()
		Local angularImpulse:Float = (_velocityBias - _body._angularVelocity) * _massFactor
		_body._angularVelocity:+(_body._inverseMomentOfInertia * Sgn(angularImpulse) * Min(Abs(angularImpulse), _maxImpulse))
	End Method
End Type
