
Type TControllerFactory

	'fixed angle spring
	rem
	bbdoc: Create a fixed angle spring
	physics is optional and if not null
	the spring will be added to the physics engine.
	end rem
	Function CreateFixedAngleSpring:TFixedAngleSpring(physics:TPhysicsSimulator, body:TBody, springConstant:Float, dampningConstant:Float)
		Local spring:TFixedAngleSpring = TFixedAngleSpring.Create(body, springConstant, dampningConstant)
		If physics <> Null Then
			physics.AddController(spring)			
		End If
		Return spring
	End Function
	
	' fixed linear spring
	rem
	bbdoc: create fixed linear spring
	physics is optional and if not null
	the spring will be added to the physics engine.
	end rem
	Function CreateFixedLinearSpring:TFixedLinearSpring(physics:TPhysicsSimulator, body:TBody, bodyAttachPoint:Vector2, worldAttachPoint:Vector2, springConstant:Float, dampningConstant:Float)
		Local spring:TFixedLinearSpring = TFixedLinearSpring.Create(body, bodyAttachPoint, worldAttachPoint, springConstant, dampningConstant)
		If physics <> Null Then
			physics.AddController(spring)
		End If
		Return spring
	End Function
	
	' linear spring
	rem
	bbdoc: create a linear spring
	physics is optional and if not null
	the spring will be added to the physics engine.
	end rem
	Function CreateLinearSpring:TLinearSpring(physics:TPhysicsSimulator, body1:TBody, attachPoint1:Vector2, body2:TBody, attachPoint2:Vector2, springConstant:Float, dampningConstant:Float)
		Local spring:TLinearSpring = TLinearSpring.Create(body1, attachPoint1, body2, attachPoint2, springConstant, dampningConstant)
		If physics <> Null Then
			physics.AddController(spring)
		End If
		Return spring
	End Function
	
	rem
	bbdoc: create an angle spring between two bodies.
	physics is optional and if not null
	the spring will be added to the physics engine.
	end rem
	Function CreateAngleSpring:TAngleSpring(physics:TPhysicsSimulator, body1:TBody, body2:TBody, springConstant:Float, dampningConstant:Float)
		Local spring:TAngleSpring = TAngleSpring.Create(body1, body2, springConstant, dampningConstant)
		If physics <> Null Then
			physics.AddController(spring)
		End If
		Return spring
	End Function
End Type
