	
Type TAngleSpring Extends TController

	Field _body1:TBody
	Field _body2:TBody
	
	Field _springConstant:Float
	Field _dampningConstant:Float
	Field _targetAngle:Float
	Field _breakpoint:Float = MathHelper.MaxValueF
	Field _maxTorque:Float = MathHelper.MaxValueF
	
	Field _springError:Float
	
	
	'#Region Properties (setter/getter)
	Method GetBody1:TBody()
		Return _body1
	End Method
	
	Method SetBody1(value:TBody)
		_body1 = value
	End Method
	
	Method GetBody2:TBody()
		Return _body2
	End Method
	
	Method SetBody2(value:TBody)
		_body2 = value
	End Method
	
	Method GetSpringConstant:Float()
		Return _springConstant
	End Method
	
	Method SetSpringConstant(value:Float)
		_springConstant = value
	End Method
	
	Method GetDampningConstant:Float()
		Return _dampningConstant
	End Method
	
	Method SetDampningConstant(value:Float)
		_dampningConstant = value
	End Method
	
	Method GetTargetAngle:Float()
		Return _targetAngle
	End Method
	
	Method SetTargetAngle(value:Float)
		_targetAngle = value

		If _targetAngle > 5.5 Then _targetAngle = 5.5
		If _targetAngle < - 5.5 Then _targetAngle = -5.5
	End Method
	
	Method GetBreakpoint:Float()
		Return _breakpoint
	End Method
	
	Method SetBreakpoint(value:Float)
		_breakpoint = value
	End Method
	
	Method GetMaxTorque:Float()
		Return _maxTorque
	End Method
	
	Method SetMaxTorque(value:Float)
		_maxTorque = value
	End Method
	
	Method GetSpringError:Float()
		Return _springError
	End Method
	'#End Region 
	
	rem
	the target angle is set to the difference
	between the total rotations of the two bodies
	end rem
	Function Create:TAngleSpring(body1:TBody, body2:TBody, springConstant:Float, dampningConstant:Float)
		Local spring:TAngleSpring = New TAngleSpring
		spring._body1 = body1
		spring._body2 = body2
		spring._springConstant = springConstant
		spring._dampningConstant = dampningConstant
		spring._targetAngle = spring._body2.GetTotalRotation() - spring._body1.GetTotalRotation()
		Return spring
	End Function
	
	Method Update(dt:Float)
		If Abs(_springError) > _breakpoint Then
			Return
		End If
		' calculate and apply spring force
	'	Local angle:Float = _body2._totalRotation - _body1._totalRotation
		Local angleDifference:Float = _body2._totalRotation - (_body1._totalRotation + _targetAngle)
		Local springTorque:Float = _springConstant * angleDifference
		_springError = angleDifference ' keep track of 'springerror' for breaking joint
		
		'apply torque at anchor
		If Not(_body1._isStatic) Then
			Local torque1:Float = springTorque - _dampningConstant * _body1._angularVelocity
			torque1 = Min(Abs(torque1), _maxTorque) * Sgn(torque1)
			_body1.ApplyTorque(torque1)
		End If
		
		If Not (_body2._isStatic) Then
			Local torque2:Float = -springTorque - _dampningConstant * _body2._angularVelocity
			torque2 = Min(Abs(torque2), _maxTorque) * Sgn(torque2)
			_body2.ApplyTorque(torque2)
		End If
	End Method
End Type
