
Type TAngleLimitJoint Extends TJoint

	Field _body1:TBody
	Field _body2:TBody
	
	Field _biasFactor:Float =.2
	Field _slop:Float =.01
	Field _softness:Float = 0
	Field _upperLimit:Float = 0
	Field _lowerLimit:Float = 0
	Field _breakPoint:Float = MathHelper.MaxValueF
	
	Field _velocityBias:Float
	Field _accumulatedAngularImpulse:Float
	Field _massFactor:Float
	Field _jointError:Float
	Field _upperLimitViolated:Int = False
	Field _lowerLimitViolated:Int = False
	
	Method GetBody1:TBody()
		Return _body1
	End Method
	
	Method SetBody1(value:TBody)
		_body1 = value
	End Method
	
	Method GetBody2:TBody()
		Return _body2
	End Method
	
	Method SetBody2(value:TBody)
		_body2 = value
	End Method
	
	Method GetBiasFactor:Float()
		Return _biasFactor
	End Method
	
	Method SetBiasFactor(value:Float)
		_biasFactor = value
	End Method
	
	
	Method GetSlop:Float()
		Return _slop
	End Method
	
	Method SetSlop(value:Float)
		_slop = value
	End Method
	
	
	Method GetSoftness:Float()
		Return _softness
	End Method
	
	Method SetSoftness(value:Float)
		_softness = value
	End Method
	
	Method GetUpperLimit:Float()
		Return _upperLimit
	End Method
	
	Method SetUpperLimit(value:Float)
		_upperLimit = value
	End Method
	
	Method GetLowerLimit:Float()
		Return _lowerLimit
	End Method
	
	Method SetLowerLimit(value:Float)
		_lowerLimit = value
	End Method
		
	Method GetBreakPoint:Float()
		Return _breakpoint
	End Method
	
	Method SetBreakPoint(value:Float)
		_breakpoint = value
	End Method
	
	Method GetJointError:Float()
		Return _jointError
	End Method
	
	Function Create:TAngleLimitJoint(body1:TBody, body2:TBody, lowerLimit:Float, upperLimit:Float)
		Local joint:TAngleLimitJoint = New TAngleLimitJoint
		joint._body1 = body1
		joint._body2 = body2
		joint._upperLimit = upperLimit
		Joint._lowerLimit = lowerLimit
		Return joint
	End Function
	
	Field _difference:Float
	Method PreStep(inversedt:Float)
		If Abs(_jointError) > _breakpoint Then Return
		_difference = (_body2._totalRotation - _body1._totalRotation)
		_jointError = 0
		
		If _difference > _upperLimit Then
			If _lowerLimitViolated Then
				_accumulatedAngularImpulse = 0
				_lowerLimitViolated = False
			End If
			_upperLimitViolated = True
			If _difference < _upperLimit + _slop Then
				_jointError = 0
			Else
				_jointError = _difference - _upperLimit
			End If
		Else If _difference < _lowerLimit
			If _upperLimitViolated Then
				_accumulatedAngularImpulse = 0
				_upperLimitViolated = False
			End If
			_lowerLimitViolated = True
			If _difference > _lowerLimit - _slop Then
				_jointError = 0
			Else
				_jointError = _difference - _lowerLimit
			End If
		Else
		
			_upperLimitViolated = False
			_lowerLimitViolated = False
			_jointError = 0
			_accumulatedAngularImpulse = 0
		End If
		_velocityBias = _biasFactor * inverseDt * _jointError
		
		_massFactor = 1.0 / (_softness + _body1._inverseMomentOfInertia + _body2._inverseMomentOfInertia)
		
		_body1._angularVelocity:-(_body1._inverseMomentOfInertia * _accumulatedAngularImpulse)
		_body2._angularVelocity:+(_body2._inverseMomentOfInertia * _accumulatedAngularImpulse)
	End Method
	
	Field _accumulatedAngularImpulseOld:Float
	Field _angularImpulse:Float
	Method Update()
		If Not(_upperLimitViolated) And Not(_lowerLimitViolated) Then
			Return
		End If

		_angularImpulse = 0
		_angularImpulse = -(_velocityBias + (_body2._angularVelocity - _body1._angularVelocity) + _softness * _accumulatedAngularImpulse) * _massFactor
		
		_accumulatedAngularImpulseOld = _accumulatedAngularImpulse
		
		If _upperLimitViolated Then
			_accumulatedAngularImpulse = Min(_accumulatedAngularImpulseOld + _angularImpulse, 0)
		Else If _lowerLimitViolated Then
			_accumulatedAngularImpulse = Max(_accumulatedAngularImpulseOld + _angularImpulse, 0)
		End If
		_angularImpulse = _accumulatedAngularImpulse - _accumulatedAngularImpulseOld
		
		_body1._angularVelocity:-_body1._inverseMomentOfInertia * _angularImpulse
		_body2._angularVelocity:+_body2._inverseMomentOfInertia * _angularImpulse
		
	End Method
	
End Type
