
Type TAngleJoint Extends TJoint

	Field _body1:TBody
	Field _body2:TBody
	
	Field _biasFactor:Float =.2
	Field _targetAngle:Float = 0
	Field _softness:Float = 0
	Field _maxImpulse:Float = MathHelper.MaxValueF
	Field _breakpoint:Float = MathHelper.MaxValueF
	
	Field _massFactor:Float
	Field _jointError:Float
	Field _velocityBias:Float
	
	Method GetBody1:TBody()
		Return _body1
	End Method
	
	Method SetBody1(value:TBody)
		_body1 = value
	End Method
	
	Method GetBody2:TBody()
		Return _body2
	End Method
	
	Method SetBody2(value:TBody)
		_body2 = value
	End Method
	
	Method GetBiasFactor:Float()
		Return _biasFactor
	End Method
	
	Method SetBiasFactor(value:Float)
		_biasFactor = value
	End Method
	
	Method GetSoftness:Float()
		Return _softness
	End Method
	
	Method SetSoftness(value:Float)
		_softness = value
	End Method
	
	Method GetBreakPoint:Float()
		Return _breakpoint
	End Method
	
	Method SetBreakPoint(value:Float)
		_breakpoint = value
	End Method
	
	Method GetJointError:Float()
		Return _jointError
	End Method
	
	Method GetTargetAngle:Float()
		Return _targetAngle
	End Method
	
	Method SetTargetAngle(value:Float)
		_targetAngle = value
	End Method
	
	Method GetMaxImpulse:Float()
		Return _maxImpulse
	End Method
	
	Method SetMaxImpulse(value:Float)
		_maxImpulse = value
	End Method
	
	Function Create:TAngleJoint(body1:TBody, body2:TBody, targetAngle:Float = 0)
		Local joint:TAngleJoint = New TAngleJoint
		joint._body1 = body1
		joint._body2 = body2
		joint._targetAngle = targetAngle
		Return joint
	End Function
	
	Method PreStep(inversedt:Float)
		If Abs(_jointError) > _breakpoint Then Return
		
		_jointError = (_body2._totalRotation - _body1._totalRotation) - _targetAngle		
		_velocityBias = -_biasFactor * inverseDt * _jointError
		_massFactor = (1 - _softness) / (_body1._inverseMomentOfInertia + _body2._inverseMomentOfInertia)		
	End Method
	
	Method Update()
		Local angularImpulse:Float = (_velocityBias - _body2._angularVelocity + _body1._angularVelocity) * _massFactor
		
		_body1._angularVelocity:-_body1._inverseMomentOfInertia * Sgn(angularImpulse) * Min(Abs(angularImpulse), _maxImpulse)
		_body2._angularVelocity:+_body2._inverseMomentOfInertia * Sgn(angularImpulse) * Min(Abs(angularImpulse), _maxImpulse)
		
	End Method

End Type
