
Type TWaveController Extends IFluidContainer

	Field _width:Float
	Field _height:Float
	Field _position:Vector2 = Vector2.Zero() 'top left
	Field _singleWaveWidth:Float
	
	Field _nodeCount:Int
	Field _dampningCoefficient:Float =.95
	Field _frequency:Float =.18 ' seconds
	
	Field _currentWave:Float[]
	Field _previousWave:Float[]
	Field _resultWave:Float[]
	Field _xPosition:Float[]
	
	Field _waveGeneratorMax:Float = 0
	Field _waveGeneratorMin:Float = 0
	Field _waveGeneratorStep:Float = 0
	Field _goingUp:Int = True
	Field _waveGeneratorCount:Float = 0
	
	Field _aabb:TAABB
	
	'#Region Public properties getter/setters
	Method GetWidth:Float()
		Return _width		
	End Method
	
	Method SetWidth(value:Float)
		_width = value
	End Method
	
	Method GetHeight:Float()
		Return _height
	End Method
	
	Method SetHeight(value:Float)
		_height = value
	End Method
	
	' top left position of wave area
	Method GetPosition:Vector2()
		Return _position.Copy()
	End Method
	
	'top left position of wave area
	Method SetPosition(value:Vector2)
		_position.Set(value)
	End Method
	
	Method GetNodeCount:Int()
		Return _nodeCount
	End Method
	
	Method SetNodeCount(value:Int)
		_nodeCount = value
	End Method
	
	
	Method GetDampningCoefficient:Float()
		Return _dampningCoefficient
	End Method
	
	Method SetDampningCoefficient(value:Float)
		_dampningCoefficient = value
	End Method
	
	Method GetCurrentWave:Float[] ()
		Return _currentWave
	End Method
	
	Method GetPreviousWave:Float[] ()
		Return _previousWave
	End Method
	
	Method GetXPosition:Float[] ()
		Return _xPosition
	End Method
	
	Method SetXPosition(value:Float[])
		_xPosition = value
	End Method
	
	Method GetWaveGeneratorMax:Float()
		Return _waveGeneratorMax
	End Method
	
	Method SetWaveGeneratorMax(value:Float)
		_waveGeneratorMax = value
	End Method
	
	Method GetWaveGeneratorMin:Float()
		Return _waveGeneratorMin
	End Method
	
	Method SetWaveGeneratorMin(value:Float)
		_waveGeneratorMin = value
	End Method
	
	Method GetWaveGeneratorStep:Float()
		Return _waveGeneratorStep
	End Method
	
	Method SetWaveGeneratorStep(value:Float)
		_waveGeneratorStep = value
	End Method
	
	Method GetFrequency:Float()
		Return _frequency
	End Method
	
	Method SetFrequency(value:Float)
		_frequency = value
	End Method
	'#End Region 
	
	
	Method New()
		
	End Method
	
	Function Create:TWaveController(position:Vector2, size:Vector2, nodeCount:Int)
		Local w:TWaveController = New TWaveController
		w.SetNodeCount(nodeCount)
		w.SetPosition(position)
		w.SetWidth(size.X)
		w.SetHeight(size.Y)
		Return w
	End Function
	
	rem
	Create a disturbance in the water surface that will create waves.
	node: Which node to change the hieght of
	offset: The amount to move the node up or down (negative values moves the node up, positive moves it down)
	end rem
	Method Disturb(node:Int, offset:Float)
		_currentWave[node] = _currentWave[node] + offset
	End Method
	
	Method Initialize()
		_xPosition = New Float[_nodeCount]
		_currentWave = New Float[_nodeCount]
		_previousWave = New Float[_nodeCount]
		_resultWave = New Float[_nodeCount]
		
		For Local i:Int = 0 To _nodeCount - 1
			_xPosition[i] = MathHelper.Lerp(_position.X, _position.X + _width, Float(i) / Float(_nodeCount - 1))
			_currentWave[i] = 0
			_previousWave[i] = 0
			_resultWave[i] = 0
		Next
		_aabb = TAABB.Create(_position, Vector2.Create(_position.X + _width, _position.Y + _height))
		_singleWaveWidth = _width / (_nodeCount - 1)
		
	End Method
	
	Field _aabbMin:Float = MathHelper.MaxValueF
	Field _timePassed:Float = 0
	Method Update(dt:Float)
		
		If _timePassed < _frequency Then
			_timePassed:+dt
			Return
		Else
			_timePassed = 0
		End If
		
		_aabbMin = MathHelper.MaxValueF
		_aabb._min.Y = _aabbMin
		For Local i:Int = 1 To _nodeCount - 2
			_resultWave[i] = (_currentWave[i - 1] + _currentWave[i + 1]) - _previousWave[i]
			_resultWave[i] = _resultWave[i] * _dampningCoefficient
			
			'keep track of aabb min val
			If (_resultWave[i] + _position.Y < _aabbMin) Then
				_aabbMin = _resultWave[i] + _position.Y
			End If
		Next
		_aabb._min.Y = _aabbMin
		_previousWave = _currentWave[..]
		_currentWave = _resultWave[..]
		
		If _goingUp Then
			If _waveGeneratorCount > _waveGeneratorMax Then
				_goingUp = False
			Else
				_waveGeneratorCount:+_waveGeneratorStep
			End If
		Else
			If _waveGeneratorCount < _waveGeneratorMin
				_goingUp = True
			Else
				_waveGeneratorCount:-_waveGeneratorStep
			End If
		End If
		_currentWave[_currentWave.Length - 1] = TConvertUnits.ToSimUnits(_waveGeneratorCount)
	End Method
	
	Method Intersect:Int(aabb:TAABB)
		Return TAABB.Intersect(aabb, _aabb)
	End Method
	
	Field vectorNearWaveEdge:Vector2 = Vector2.Zero()
	Field vectorFarWaveEdge:Vector2 = Vector2.Zero()
	Field vectorPoint:Vector2 = Vector2.Zero()
	
	Field _waveEdgeVector:Vector2 = Vector2.Zero()
	Field _pointVector:Vector2 = Vector2.Zero()
	Method Contains:Int(vector:Vector2)
		'do i need a try catch block here?
		Local index:Int = Floor((vector.X - _xPosition[0]) / _singleWaveWidth)
		' handle boundry conditions
		If index > _nodeCount - 2 Then index = _nodeCount - 2
		If index < 0 Then index = 0
		
		vectorNearWaveEdge.X = _xPosition[index]
		vectorNearWaveEdge.Y = _position.Y + _currentWave[index]
		
		vectorFarWaveEdge.X = _xposition[index + 1]
		vectorFarWaveEdge.Y = _position.Y = _currentWave[index + 1]
		
		vectorPoint.X = vector.X
		vectorPoint.Y = vector.Y
		
		_waveEdgeVector.X = _xPosition[index + 1] - _xposition[index]
		_waveEdgeVector.Y = _currentWave[index + 1] - _currentWave[index]
		
		_pointVector.X = vector.X - _xposition[index]
		_pointVector.Y = vector.Y - (_position.Y + _currentWave[index])
		
		
		Local perpDot:Float = Calculator.CrossVV(_waveEdgeVector, _pointVector)
		If perpDot < 0 Then
			Return False
		Else
			Return True
		End If
	End Method
End Type
