

Type TVertices

'#Region Private Members
	Field _vecArray:Vector2[] 
	Field _vectorTemp1:Vector2 = Vector2.Zero() 
	Field _vectorTemp2:Vector2 = Vector2.Zero() 
	Field _vectorTemp3:Vector2 = Vector2.Zero() 
'#End Region 
	
'#Region Properties	
	Method GetVerticesArray:Vector2[] () 
		Local v:Vector2[_vecArray.Length] 
		For Local i:Int = 0 To v.Length - 1
			v[i] = _vecArray[i].Copy() 
		Next
		Return v
	End Method
'#End Region 
	
	Method New() 
		
	End Method
	
'#Region Constructors
	Function Create:TVertices(vectors:Vector2[] ) 
		Local vertices:TVertices = New TVertices
		For Local i:Int = 0 To vectors.Length - 1
			vertices.add(vectors[i] ) 
		Next
		Return vertices
	End Function
	
	Function CreateFromVertices:TVertices(vertices:TVertices) 
		Local v:TVertices = New TVertices
		For Local i:Int = 0 To vertices._vecArray.Length - 1
			v.add(vertices._vecArray[i] ) 
		Next		
		Return v
	End Function
	
	Function CreateRectangle:TVertices(width:Float, height:Float) 
		Local vertices:TVertices = New TVertices
		vertices.add(Vector2.Create(- width *.5, - height *.5)) 
		vertices.add(Vector2.Create(- width *.5, - height *.25)) 
		vertices.add(Vector2.Create(- width *.5, 0)) 
		vertices.add(Vector2.Create(- width *.5, height *.25)) 
		vertices.add(Vector2.Create(- width *.5, height *.5)) 
		vertices.add(Vector2.Create(- width *.25, height *.5)) 
		vertices.add(Vector2.Create(0, height *.5)) 
		vertices.add(Vector2.Create(width *.25, height *.5)) 
		vertices.add(Vector2.Create(width *.5, height *.5)) 
		vertices.add(Vector2.Create(width *.5, height *.25)) 
		vertices.add(Vector2.Create(width *.5, 0)) 
		vertices.add(Vector2.Create(width *.5, - height *.25)) 
		vertices.add(Vector2.Create(width *.5, - height *.5)) 
		vertices.add(Vector2.Create(width *.25, - height *.5)) 
		vertices.add(Vector2.Create(0, - height *.5)) 
		vertices.add(Vector2.Create(- width *.25, - height *.5)) 
		Return vertices
	End Function
	
	Function CreateCircle:TVertices(radius:Float, numberOfEdges:Int) 
		Local vertices:TVertices = New TVertices
		Local stepSize:Float = MathHelper.TwoPi / Float(numberOfEdges) 
		vertices.add(Vector2.Create(radius, 0)) 
		For Local i:Int = 1 To numberOfEdges - 1
			Local degrees:Float = MathHelper.ToDegrees(stepsize) 
			vertices.add(Vector2.Create(radius * Cos(degrees * i), - radius * Sin(degrees * i))) 			
		Next
		Return vertices
	End Function
'#End Region 

	rem
	bbdoc: since geomerty isn't as dynamic
	we grow the vec array by 1 each time we add one
	to simplify indexing. vector is passed by value.
	end rem
	Method Add(vector:Vector2) 
		If _vecArray = Null Then
			_vecArray = New Vector2[1] 
			_vecArray[0] = vector.Copy() 
			Return
		End If
		_vecArray = _vecArray + New Vector2[1] 
		_vecArray[_vecArray.Length - 1] = vector.Copy() 
	End Method
	
	Method Clear() 
		_vecArray = Null
		Self._vectorTemp1.SetParts(0, 0)
		Self._vectorTemp2.SetParts(0, 0)
		Self._vectorTemp3.SetParts(0, 0)
		Self._vectorTemp4.SetParts(0, 0)
		Self._vectorTemp5.SetParts(0, 0)
		
	End Method
	
	Method NextIndex:Int(index:Int) 
		If index = _vecArray.Length - 1 Then
			Return 0
		Else
			Return index + 1
		End If
	End Method
	
	Method Reverse() 
		Local list:TList = TList.FromArray(_vecArray)
		Clear()
		Local revList:TList = list.Reversed() 
		For Local v:Vector2 = EachIn revList
			Self.add(v) 
		Next
	End Method
	
	Method Count:Int() 
		Return _vecArray.Length
	End Method
	
	Method PreviousIndex:Int(index:Int) 
		If index = 0 Then
			Return _vecArray.Length - 1
		Else
			Return index - 1
		End If
	End Method
	
	Method GetEdge:Vector2(index:Int) 
		Local nIndex:Int = NextIndex(index) 

		_vectorTemp2.X = _vecarray[nIndex].X
		_vectorTemp2.Y = _vecArray[nIndex].Y
				
		_vectorTemp3.X = _vecArray[index].X
		_vectorTemp3.Y = _vecArray[index].Y
		
		Vector2.SubtractVectorsRef(_vectorTemp2, _vectorTemp3, _vectorTemp1) 
		Return _vectorTemp1.Copy() 
	End Method
	
	Method GetEdgeRef(index:Int, outEdge:Vector2) 
		Local nIndex:Int = NextIndex(index) 
	
		_vectorTemp2.X = _vecarray[nIndex].X
		_vectorTemp2.Y = _vecArray[nIndex].Y
				
		_vectorTemp3.X = _vecArray[index].X
		_vectorTemp3.Y = _vecArray[index].Y
		Vector2.SubtractVectorsRef(_vectorTemp2, _vectorTemp3, outEdge) 		
	End Method
	
	Method GetEdgeMidPoint:Vector2(index:Int) 
		GetEdgeRef(index, _vectorTemp1) 
		Vector2.ScaleRef(_vectorTemp1, .5, _vectorTemp2) 
		
		_vectorTemp3.X = _vecArray[index].X
		_vectorTemp3.Y = _vecArray[index].Y
		
		Vector2.AddVectorsRef(_vectorTemp3, _vectorTemp2, _vectorTemp1)
		Return _vectorTemp1.Copy() 
	End Method
	
	Method GetEdgetMidPointRef(index:Int, outMidPoint:Vector2) 
		GetEdgeRef(index, _vectorTemp1) 
		Vector2.ScaleRef(_vectorTemp1, .5, _vectorTemp2) 
		_vectorTemp3.X = _vecArray[index].X
		_vectorTemp3.Y = _vecArray[index].Y 
		Vector2.AddVectorsRef(_vectorTemp3, _vectorTemp2, outMidPoint)
	End Method
	
	
	Method GetEdgeNormal:Vector2(index:Int) 
		GetEdgeRef(index, _vectorTemp1) 
		_vectorTemp2.X = -_vectorTemp1.Y
		_vectorTemp2.Y = _vectorTemp1.X
		
		Vector2.NormalizeRef(_vectorTemp2, _vectorTemp3) 
		Return _vectorTemp3.Copy() 
	End Method
	
	Field _vectorTemp4:Vector2 = Vector2.Zero() 
	Field _vectorTemp5:Vector2 = Vector2.Zero() 
	Method GetEdgeNormalRef(index:Int, outEdgeNormal:Vector2) 
			GetEdgeRef(index, _vectorTemp4) 
			_vectorTemp5.X = -_vectorTemp4.Y
			_vectorTemp5.Y = _vectorTemp4.X
			Vector2.NormalizeRef(_vectorTemp5, outEdgeNormal) 
	End Method
	
	Method GetVertexNormal:Vector2(index:Int) 
		GetEdgeNormalRef(index, _vectorTemp1) 
		
		Local prevIndex:Int = PreviousIndex(index) 
		GetEdgeNormalRef(prevIndex, _vectorTemp2) 	
		Vector2.AddVectorsRef(_vectorTemp1, _vectorTemp2, _vectorTemp3)
		Vector2.NormalizeRef(_vectorTemp3, _vectorTemp1) 
		Return _vectorTemp1.Copy() 
	End Method
	
	Method GetVertexNormalRef(index:Int, outVertexNormal:Vector2) 
		GetEdgeNormalRef(index, _vectorTemp1) 	
		Local prevIndex:Int = PreviousIndex(index) 
		GetEdgeNormalRef(prevIndex, _vectorTemp2) 
		Vector2.AddVectorsRef(_vectorTemp1, _vectorTemp2, _vectorTemp3) 
		Vector2.NormalizeRef(_vectorTemp3, outVertexNormal) 
	End Method
	
	'TODO: make the distance test do square
	' distance and just have a single squareroot call
	' at the end
	Method GetShortestEdge:Float() 
		Local shortestEdge:Float = MathHelper.MaxValueF
		For Local i:Int = 0 To _vecArray.Length - 1
			GetEdgeRef(i, _vectorTemp1) 
			Local length:Float = _vectorTemp1.Length() 
			If length < shortestEdge Then
				shortestEdge = length
			End If
		Next
		Return shortestEdge
	End Method
	
	Method SubDivideEdges(maxEdgeLength:Float) 
		Local verticesTemp:TVertices = New TVertices
		Local edgeCount:Double
		Local edgeLength:Float
		Local vertA:Vector2 = Vector2.Zero() 
		Local vertB:Vector2 = Vector2.Zero() 
		Local edge:Vector2 = Vector2.Zero() 
		For Local i:Int = 0 To _vecArray.Length - 1
			vertA = _vecArray[i] 
			vertB = _vecArray[NextIndex(i)] 
			edge = Vector2.Zero() 
			Vector2.SubtractVectorsRef(verta, vertb, edge) 
			edgeLength = edge.Length() 
			
			verticesTemp.add(vertA) 
			If edgeLength > maxEdgeLength Then
				edgeCount = Ceil(edgeLength / maxEdgeLength) 
				
				For Local j:Int = 0 To edgeCount - 1
					Local vert:Vector2 = Vector2.Lerp(vertA, vertB, Float(j + 1) / Float(edgeCount)) 
					verticesTemp.add(vert) 
				Next
			End If
		Next
		Clear() 
		For Local k:Int = 0 To verticesTemp._vecArray.Length - 1
			Self.add(verticesTemp._vecArray[k] ) 
		Next
	End Method
	
	Method ForceCounterClockWiseOrder() 
		Local area:Float = _GetSignedArea() 
		If area > 0 Then
			Reverse()
		End If
	End Method
	
	Method _GetSignedArea:Float() 
		Local i:Int, j:Int
		Local area:Float = 0
		For i = 0 To _vecArray.Length - 1
			j = (i + 1) Mod _vecArray.Length
			area:+_vecArray[i].X * _vecArray[j].Y
			area:-_vecArray[i].Y * _vecArray[j].X
		Next
		area = area / 2
		Return area
	End Method
	
	Method GetArea:Float() 
		Local i:Int, j:Int
		Local area:Float = 0
		For i = 0 To _vecArray.Length - 1
			j = (i + 1) Mod _vecArray.Length
			area:+_vecArray[i].X * _vecArray[j].Y
			area:-_vecArray[i].Y * _vecArray[j].X
		Next
		area = area / 2
		Return Abs(area) 
	End Method
	
	Field _res:Vector2 = Vector2.Zero() 
	Method GetCentroid:Vector2() 
		Local area:Float = GetArea() 
		Return GetCentroidByArea(area) 
	End Method
	
	Method GetCentroidByArea:Vector2(area:Float) 
		' calc centroid on counter clockwise verts
		Local verts:TVertices = TVertices.CreateFromVertices(Self) 
		verts.ForceCounterClockWiseOrder() 
		Local cx:Float = 0, cy:Float = 0
		Local i:Int, j:Int
		
		Local factor:Float = 0
		For i = 0 To _vecArray.Length - 1
			j = (i + 1) Mod _vecArray.Length
			factor = -(verts._vecArray[i].X * verts._vecArray[j].Y - verts._vecArray[j].X * verts._vecArray[i].Y) 
			cx:+(verts._vecArray[i].X + verts._vecArray[j].X) * factor
			cy:+(verts._vecArray[i].Y + verts._vecArray[j].Y) * factor
		Next
		area:*6.0
		factor = 1 / area
		cx:*factor
		cy:*factor
		_res.X = cx
		_res.Y = cy
		Return _res.Copy() 
	End Method
	
	Method GetMomentOfInertia:Float() 
		Local verts:TVertices = TVertices.CreateFromVertices(Self) 
		verts.ForceCounterClockWiseOrder() 
		Local centroid:Vector2 = verts.GetCentroid() 
		verts.Translate(centroid.Copy().Scale(- 1)) 
		
		If verts.Count() = 0 Then Throw "vertexes invalid to calculate moment of inertia"
		If verts.Count() = 1 Then Return 0
		
		Local denom:Float = 0
		Local numer:Float = 0
		Local a:Float, b:Float, c:Float, d:Float
		Local v1:Vector2 = Vector2.Zero() 
		Local v2:Vector2 = Vector2.Zero() 
		v1 = verts._vecArray[verts.Count() - 1] 
		For Local index:Int = 0 To verts.Count() - 1
			v2 = verts._vecArray[index] 
			a = Vector2.Dot(v2, v2) 
			b = Vector2.Dot(v2, v1) 
			c = Vector2.Dot(v1, v1) 
			d = Calculator.CrossVV(v1, v2) 
			d = Abs(d) 
			numer:+d
			denom:+(a + b + c) * d
			v1 = v2
		Next
		Return denom / (numer * 6) 
	End Method
	
	Method ProjectToAxis(axis:Vector2, minf:Float Var, maxf:Float Var) 
		' to project a point on an axis use the dot product
		Local dotProduct:Float = Vector2.Dot(axis, _vecArray[0] ) 
		minf = dotProduct
		maxf = dotProduct
		
		For Local i:Int = 0 To Count() - 1
			dotProduct = Vector2.Dot(_vecArray[i] , axis) 
			If dotProduct < minf Then
				minf = dotProduct
			Else
				If dotProduct > maxf Then
					maxf = dotProduct
				End If
			End If			
		Next
	End Method
	
	Method Translate(vector:Vector2) 
		For Local i:Int = 0 To Count() - 1
			_vecArray[i].add(vector) 
		Next
	End Method
	
	Method ToString:String() 
		Local output:String = ""
		For Local i:Int = 0 To Count() - 1
			output = output + _vecArray[i].ToString() 
			If i < count() - 1 Then
				output = output + " "
			End If
		Next
		Return output
	End Method
End Type
