
Type TGrid
	
	Field _gridCellSize:Float
	Field _gridCellSizeInv:Float
	Field _aabb:TAABB
	Field _nodes:Float[,] 
	Field _points:Vector2[] 
	
	Method GetPoints:Vector2[] () 
		Return _points
	End Method
	
	Method New() 
		
	End Method
	
	Method Clone:TGrid() 
		Local grid:TGrid = New TGrid
		grid._gridCellSize = _gridCellSize
		grid._gridCellSizeInv = _gridCellSizeInv
		grid._aabb = TAABB.CreateFromAABB(_aabb) 
		grid._nodes = _CopyNodes() 
		grid._points = _CopyPoints() 
		Return grid
	End Method
	
	Method _CopyPoints:Vector2[] () 
		Local v:Vector2[_points.Length] 
		For Local i:Int = 0 To v.Length - 1
			v[i] = _points[i].Copy() 
		Next
		Return v
	End Method
	
	Method _CopyNodes:Float[,] () 
		Local copy:Float[,] = New Float[_nodes.Dimensions()[0] , _nodes.Dimensions()[1] ] 
		For Local i:Int = 0 To _nodes.Dimensions()[0] - 1
			For Local j:Int = 0 To _nodes.Dimensions()[1] - 1
				copy[i, j] = _nodes[i, j] 				
			Next
		Next
		Return copy
	End Method
	
	Method ComputeGrid(geometry:TGeom, gridCellSize:Float) 
		
		' prepare geometry
		Local old:TMatrix = geometry.GetMatrix()

		Local identity:TMatrix = TMatrix.Identity() 
		geometry.SetMatrix(identity) 
		_aabb = TAABB.CreateFromAABB(geometry.GetAABB())
		_gridCellSize = gridCellSize
		_gridCellSizeInv = 1 / gridCellSize
		
		Local xSize:Int = Ceil(Double((_aabb._max.X - _aabb._min.X) * _gridCellSizeInv)) + 1
		Local ySize:Int = Ceil(Double((_aabb._max.Y - _aabb._min.Y) * _gridCellSizeInv)) + 1
		_nodes = New Float[xSize, ySize]
		_points = New Vector2[xSize * ySize] 
		Local i:Int = 0
		Local vector:Vector2 = _aabb.GetMin() 
		For Local x:Int = 0 To xSize - 1
			vector.Y = _aabb._min.Y
			For Local y:Int = 0 To ySize - 1			
				_nodes[x, y] = geometry.GetNearestDistance(vector) 
				_points[i] = vector.Copy()
				i:+1
				vector.Y:+_gridCellSize
			Next
			vector.X:+_gridCellSize
		Next
		

		geometry.SetMatrix(old)
	End Method
	
	Field _normalTemp:Vector2 = Vector2.Zero() 
	Method Intersect:Int(vector:Vector2, outFeature:TFeature Var) 

		'TODO:Keep And eye out For floating point accuracy issues here.Possibly some
        'VERY intermittent errors exist?
		If _aabb.Contains(vector) Then
			Local x:Int = Int(Floor((vector.X - _aabb._min.X) * _gridCellSizeInv)) 
			Local y:Int = Int(Floor((vector.Y - _aabb._min.Y) * _gridCelLSizeInv)) 
			
			Local xPercent:Float = (vector.X - (_gridCellSize * x + _aabb._min.X)) * _gridCellSizeInv
			Local yPercent:Float = (vector.Y - (_gridCellSize * y + _aabb._min.Y)) * _gridCellSizeInv
			
			Local bottomLeft:Float = _nodes[x, y] 
			Local bottomRight:Float = _nodes[x + 1, y] 
			Local topLeft:Float = _nodes[x, y + 1] 
			Local topRight:Float = _nodes[x + 1, y + 1] 
			
			If bottomLeft <= 0 Or bottomRight <= 0 Or topLeft <= 0 Or topRight <= 0 Then
				Local top:Float, bottom:Float, distance:Float
				
				top = MathHelper.Lerp(topLeft, topRight, xPercent) 
				bottom = MathHelper.Lerp(bottomLeft, bottomRight, xPercent) 
				distance = MathHelper.Lerp(bottom, top, yPercent) 
				
				If distance <= 0 Then
					Local r:Float, l:Float ' right/left
					
					r = MathHelper.Lerp(bottomRight, topRight, yPercent) 
					l = MathHelper.Lerp(bottomLeft, topLeft, yPercent) 
					 
					_normalTemp.X = r - l
					_normalTemp.Y = top - bottom
					_normalTemp.Normalize()
					outfeature.Init(vector, _normalTemp, distance)
			'		outfeature = TFeature.Create2(vector, _normalTemp, distance)
					Return True
				End If
			End If
		End If
	'	outFeature = New TFeature
		outfeature.Reset()
		Return False
	End Method
End Type
