
Type TGeomFactory

	Global _gridcellSizeAABBFactor:Float =.1
	
	Function SetGridCellSizeAABBFactor(value:Float) 
		_gridCellSizeAABBFactor = value
	End Function
	
	Function GetGridCelLSizeAABBFactor:Float() 
		Return _gridCellSizeAABBFactor
	End Function
	
	'rectangle
	rem
	bbdoc: physics is an optional parameter. if not null
	this geom will be added to the physics engine
	end rem
	Function CreateRectangleGeom:TGeom(physics:TPhysicsSimulator, body:TBody, width:Float, height:Float, offset:Vector2 = Null, rotationOffset:Float = 0, collisionGridCellSize:Float = -1)
		Local v:TVertices = TVertices.CreateRectangle(width, height)
		If collisionGridCellSize < 0 Then collisionGridCellSize = CalculateGridCellSizeFromAABB(v) 
		Local g:TGeom = TGeom.Create(body, v, collisionGridCellSize, offset, rotationOffset) 
		If physics <> Null Then
			physics.AddGeom(g)
		End If
		Return g
	End Function
	
	'circles	
	rem
	bbdoc: create a circle geometry object.
	physics is optional.if not null
	this geom will be added to the physics engine
	end rem
	Function CreateCircleGeom:TGeom(physics:TPhysicsSimulator, body:TBody, radius:Float, numberOfEdges:Int, offset:Vector2 = Null, rotationOffset:Float = 0, collisionGridCellSize:Float = -1)
		Local v:TVertices = TVertices.CreateCircle(radius, numberOfEdges) 
		If collisionGridCellSize < 0 Then collisionGridCellSize = CalculateGridCellSizeFromAABB(v) 
		Local g:TGeom = TGeom.Create(body, v, collisionGridCellSize, offset, rotationOffset) 
		If physics <> Null Then
			physics.AddGeom(g)
		End If
		Return g
	End Function
	
	' polygons	
	rem
	bbdoc: create polygon geometry based off a set
	of vertices. physics is optional. if not null
	this geom will be added to the physics engine
	end rem
	Function CreatePolygonGeom:TGeom(physics:TPhysicsSimulator, body:TBody, vertices:TVertices, offset:Vector2 = Null, rotationOffset:Float = 0, collisionGridCellSize:Float = -1)
		Local centroid:Vector2 = vertices.GetCentroid() 
		vertices.Translate(centroid.Scale(- 1))
		If collisionGridCellSize < 0 Then collisionGridCellSize = CalculateGridCellSizeFromAABB(vertices) 
		Local g:TGeom = TGeom.Create(body, vertices, collisionGridCellSize, offset, rotationOffset)
		If physics <> Null Then
			physics.AddGeom(g)
		End If
		Return g
	End Function
	
	'cloning	
	rem
	bbdoc: clone a given geometry to a body
	physics is optional. if not null
	this geom will be added to the physics engine
	end rem
	Function CloneGeom:TGeom(physics:TPhysicsSimulator, body:TBody, geom:TGeom, offset:Vector2 = Null, rotationOffset:Float = 0)
		Local clone:TGeom = TGeom.CreateFromClone(body, geom, offset, rotationOffset)
		If physics <> Null Then
			physics.AddGeom(clone)
		End If
		Return clone
	End Function
	
	Function CalculateGridCellSizeFromAABB:Float(vertices:TVertices) 
		Local aabb:TAABB = TAABB.CreateFromVertices(vertices) 
		Return aabb.GetShortestSide() * _gridcellSizeAABBFactor
	End Function
End Type
