'This BMX file was edited with BLIde ( http://www.blide.org )
Rem
 bbdoc:Undocumented type
End Rem
Type TGeom

'#Region Private Members
	Field _position:Vector2 = Vector2.Zero() 
	Field _rotation:Float = 0
	Field _collisionGridCellSize:Float
	Field _offset:Vector2 = Vector2.Zero() 
	Field _rotationOffset:Float = 0
	Field _restitutionCoefficient:Float = 0
	Field _frictionCoefficient:Float = 0
	Field _tag:Object
	Field _collisionGroup:Int = 0
	Field _collisionEnabled:Int = True
	Field _collisionResponseEnabled:Int = True
	Field _collisionCategories:Int = CollisionCategories.All
	Field _collidesWith:Int = CollisionCategories.All
	
	Field _id:Int
	Field _grid:TGrid
	Field _localVertices:TVertices
	Field _worldVertices:TVertices
	Field _matrix:TMatrix = TMatrix.Identity() 
	Field _matrixInverse:TMatrix = TMatrix.Identity() 
	Field _aabb:TAABB = New TAABB
	Field _matrixInverseTemp:TMatrix
	Field _body:TBody
	
	Field isRemoved:Int ' public field for speed purposes. true->geometry removed from simulation
	
	'event handling
	Field _bodyOnChange:TGeomBodyListener
	Field _collisionEventListeners:TList = CreateList()
'#End Region 

'#Region Properties
	Method GetId:Int() 
		Return _id
	End Method
	
	Method GetMatrix:TMatrix() 
		Return _matrix.Copy() 
	End Method
	
	Method SetMatrix(matrix:TMatrix) 
		_matrix = matrix.Copy()
		Self._Update()
	End Method
	
	Method GetMatrixInverse:TMatrix() 
		TMatrix.InvertRef(_matrix, _matrixInverse) 
		Return _matrixInverse
	End Method
	
	Method GetAABB:TAABB() 
		Return _aabb
	End Method
	
	Method GetPosition:Vector2() 
		Return _position.Copy() 
	End Method
	
	Method GetRotation:Float() 
		Return _rotation
	End Method
	
	Method SetCollisionGridCellSize(value:Float) 
		_collisionGridCellSize = value
		Self.ComputeCollisionGrid()
	End Method
	
	Method GetCollisionGridCellSize:Float() 
		Return _collisionGridCellSize
	End Method
	
	Method GetLocalVertices:TVertices() 
		Return _localVertices
	End Method
	
	Method SetLocalVertices(value:TVertices) 
		_localVertices = value
	End Method
	
	Method GetWorldVertices:TVertices() 
		Return _worldVertices
	End Method
	
	Method SetWorldVertices(value:TVertices) 
		_worldVertices = value
	End Method
	
	rem
	bbdoc: objects in the same collision group do not collide with each other
	end rem
	Method GetCollisionGroup:Int() 
		Return _collisionGroup
	End Method
	
	rem
	bbdoc: objects in the same collision group do not collide with each other
	end rem
	Method SetCollisionGroup(value:Int) 
		_collisiongroup = value
	End Method
	
	Method SetCollisionEnabled(value:Int) 
		_collisionEnabled = value
	End Method
	
	Method GetCollisionEnabled:Int() 
		Return _collisionEnabled
	End Method
	
	Method SetCollisionResponseEnabled(value:Int) 
		_collisionResponseEnabled = value
	End Method
	
	Method GetcollisionResponseEnabled:Int() 
		Return _collisionResponseEnabled
	End Method
	
	Method GetCollisionCategory:Int()
		Return _collisionCategories
	End Method
	
	Method SetCollisionCategory(value:Int)
		_collisionCategories = value
	End Method
	
	Method GetCollidesWith:Int() 
		Return _collidesWith
	End Method
	
	Method SetCollidesWith(value:Int) 
		_collidesWith = value
	End Method
	
	Method GetGrid:TGrid() 
		Return _grid
	End Method
	
	Method GetBody:TBody() 
		Return _body
	End Method
	
	rem
	The coefficient of restitution of the geometry.
	This parameter controls how bouncy an object is when it collides with other
	geometries. Valid values range from 0 to 1 inclusive.  1 implies 100% restitution (perfect bounce)
	0 implies no restitution (think a ball of clay)	
	end rem
	Method GetRestitutionCoefficient:Float() 
		Return _restitutionCoefficient
	End Method
	rem
	The coefficient of restitution of the geometry.
	This parameter controls how bouncy an object is when it collides with other
	geometries. Valid values range from 0 to 1 inclusive.  1 implies 100% restitution (perfect bounce)
	0 implies no restitution (think a ball of clay)	
	end rem
	Method SetRestitutionCoefficient(value:Float) 
		_restitutionCoefficient = value
	End Method
	
	rem
	Controls the amount of friction a geometry has when in contact with another geometry. A value of zero implies
    no friction.  When two geometries collide, the minimum friction coeficent between the two bodies is used.
	end rem
	Method GetFrictionCoefficient:Float() 
		Return _frictionCoefficient
	End Method
	
	rem
	Controls the amount of friction a geometry has when in contact with another geometry. A value of zero implies
    no friction.  When two geometries collide, the minimum friction coeficent between the two bodies is used.
	end rem
	Method SetFrictionCoefficient(value:Float) 
		_frictionCoefficient = value
	End Method
	
	Method GetTag:Object() 
		Return _tag
	End Method
	
	Method SetTag(value:Object) 
		_tag = value
	End Method
	
	Method SetVertices(vertices:TVertices)
		vertices.ForceCounterClockWiseOrder()
		_localVertices = TVertices.CreateFromVertices(vertices)
		_worldVertices = TVertices.CreateFromVertices(vertices) 
		_aabb.Update(vertices)
	End Method
	
	Method SetBody(body:TBody) 
		_body = body
				
		Self._bodyOnChange = TGeomBodyListener.Create(Self)
		_body.updateHandler.add(_bodyOnChange) 
		
		_Update2(body._position, _body._rotation) 
	End Method
'#End Region 

'#Region Construction
	Function Create:TGeom(body:TBody, vertices:TVertices, collisionGridCellSize:Float, offset:Vector2 = Null, rotationOffset:Float = 0) 
		Local g:TGeom = New TGeom
		If offset = Null Then
			offset = Vector2.Zero() 
		End If
		g._Construct(body, vertices, offset, rotationOffset, collisionGridCellSize) 
		Return g
	End Function
	
	Function CreateFromClone:TGeom(body:TBody, geom:TGeom, offset:Vector2 = Null, rotationOffset:Float = 0) 
		If offset = Null Then
			offset = Vector2.Zero() 
		End If
		Local g:TGeom = New TGeom
		g._ConstructClone(body, geom, offset, rotationOffset) 
		Return g
	End Function
	
	Method _Construct(body:TBody, vertices:TVertices, offset:Vector2, rotationOffset:Float, collisionGridCellSize:Float) 
		_id = GetNextId() 
		Self._collisionGridCellSize = collisionGridcellSize
		Self._grid = New TGrid
		Self._offset = offset
		Self._rotationOffset = rotationOffset
		Self.SetVertices(vertices) 
		Self.ComputeCollisionGrid()  		
		Self.SetBody(body)
	End Method
	
	Method _ConstructClone(body:TBody, geometry:TGeom, offset:Vector2, rotationOffset:Float) 
		_id = GetNextId() 
		Self._collisionGridCellSize = geometry._collisionGridCellSize
		Self._grid = geometry._grid.Clone() 
		_restitutionCoefficient = geometry._restitutionCoefficient
		_frictionCoefficient = geometry._frictionCoefficient
		_collisionGroup = geometry._collisionGroup
		_collisionEnabled = geometry._collisionEnabled
		_collisionResponseEnabled = geometry._collisionResponseEnabled
		_offset.X = offset.X
		_offset.Y = offset.Y
		_rotationOffset = rotationOffset
		_collisionCategories = geometry._collisionCategories
		_collidesWith = geometry._collidesWith
		SetVertices(geometry._localVertices) 
		SetBody(body) 
	End Method
	
	Method New() 
	'	_id = GetNextId() 

	End Method
	
	Global _newId:Int = -1
	Function GetNextId:Int() 
		_newId:+1		
		Return _newId
	End Function
'#End Region 

	Method ComputeCollisionGrid() 
		If _localvertices.Count() > 2 Then
			_grid.ComputeGrid(Self, _collisionGridCellSize)
		Else
			_grid = Null
		End If
	End Method
	
	Method GetWorldPosition:Vector2(localPosition:Vector2) 
		Local retVector:Vector2 = Vector2.Zero() 
		Vector2.TransformRef(localPosition, _matrix, retVector)
		Return retVector
	End Method
	
	Method GetNearestDistance:Float(point:Vector2) 
		Local distance:Float
		Local nearestFeature:TFeature = TFeature.Create(point) 
		nearestfeature.Distance = MathHelper.MaxValueF
		For Local i:Int = 0 To _localVertices.Count() - 1
			Local feature:TFeature = GetNearestFeature(point, i) 
			If feature.Distance < nearestFeature.Distance Then
				nearestFeature = feature
			End If
		Next
		' determine if inside or outside geometry
		Local diff:Vector2 = Vector2.SubtractVectors(point, nearestFeature.Position) 
		Local dot:Float = Vector2.Dot(diff, nearestfeature.Normal) 
		If dot < 0 Then
			distance = -nearestFeature.Distance
		Else
			distance = nearestfeature.Distance
		End If
		Return distance
	End Method
	
	
	Method GetNearestFeature:TFeature(point:Vector2, index:Int) 
		Local feature:TFeature = New TFeature
		Local v:Vector2 = _localVertices.GetEdge(index) 
		Local w:Vector2 = Vector2.SubtractVectors(point, _localVertices._vecArray[index] ) 

		Local c1:Float = Vector2.Dot(w, v) 
		If c1 < 0 Then
			feature.Position.X = _localVertices._vecArray[index].X
			feature.Position.Y = _localVertices._vecArray[index].Y
			
			feature.Normal = _localVertices.GetVertexNormal(index) 
			feature.Distance = Abs(w.Length()) 

			Return feature
		End If

		Local c2:Float = Vector2.Dot(v, v) 
		If c2 <= c1 Then
			Local d1:Vector2 = Vector2.SubtractVectors(point, _localVertices._vecArray[_localVertices.NextIndex(index)] ) 
			feature.Position.X = _localVertices._vecArray[_localVertices.NextIndex(index)].X
			feature.Position.Y = _localVertices._vecArray[_localVertices.NextIndex(index)].Y
			
			feature.Normal = _localVertices.GetVertexNormal(_localVertices.NextIndex(index)) 
			feature.Distance = Abs(d1.Length()) 
			Return feature
		End If

		Local b:Float = c1 / c2
		v = Vector2.ScaleVector(v, b) 
		Local Pb:Vector2 = Vector2.AddVectors(_localVertices._vecArray[index] , v) 
		Local d2:Vector2 = Vector2.SubtractVectors(point, Pb) 
		feature.Position = Pb
		feature.Normal = _localVertices.GetEdgeNormal(index) 
		feature.Distance = d2.Length() 

		Return feature
		
	End Method
	
	Field _pointVecTemp:Vector2 = Vector2.Zero() 
	Method Collide:Int(point:Vector2) 
		Local feature:TFeature = New TFeature
		_pointVecTemp.X = point.X
		_pointVecTemp.Y = point.Y
		Vector2.TransformRef(point, Self.GetMatrixInverse(), _pointVecTemp)
		_grid.Intersect(_pointVecTemp, feature) 
		If feature.Distance < 0 Then
			Return True
		Else
			Return False
		End If
	End Method
	
	Field _vert:Vector2 = Vector2.Zero() 
	Method CollideWithGeometry:Int(geometry:TGeom) 
		For Local i:Int = 0 To _worldVertices.Count() - 1
			_vert = _worldVertices._vecArray[i] 
			If geometry.Collide(_vert) Then
				Return True
			End If
		Next
		
		For Local i:Int = 0 To geometry._worldVertices.Count() - 1
			_vert = geometry._worldVertices._vecArray[i]
			If Self.Collide(_vert) Then
				Return True
			End If
		Next
		
		Return False
	End Method
	
	Method Intersect:Int(localVertex:Vector2, outFeature:TFeature Var) 
		Return _grid.Intersect(localVertex, outFeature) 
	End Method
	
	Method TransformToLocalCoordinates(worldVertex:Vector2, outLocalVertex:Vector2) 
		Self._matrixInverseTemp = Self.GetMatrixInverse() 
		Vector2.TransformRef(worldVertex, _matrixInverseTemp, outLocalVertex)
	End Method
	
	Method TransformNormalToWorld(localNormal:Vector2, outWorldNormal:Vector2 Var) 
		Vector2.TransformNormalRef(localNormal, _matrix, outWorldNormal)
	End Method
	
	Field _newPos:Vector2 = Vector2.Zero() 
	Method _Update2(position:Vector2, orientation:Float) 
		TMatrix.CreateRotationZRef(orientation + _rotationOffset, _matrix) 
		
		'#region INLINE:Vector2.TransformRef(ref offset, ref matrix, out newPos) ;
		Local num2:Float = ((_offset.X * _matrix.M11) + (_offset.Y * _matrix.M21)) + _matrix.M41
		Local num:Float = ((_offset.X * _matrix.M12) + (_offset.Y * _matrix.M22)) + _matrix.M42
		_newPos.X = num2
		_newPos.Y = num
		'#endregion
		
		_matrix.M41 = position.X + _newPos.X
		_matrix.M42 = position.Y + _newPos.Y
		_matrix.M44 = 1
		_position.X = _matrix.M41
		_position.Y = _matrix.M42
		_rotation = _body._rotation + _rotationOffset
		_Update() 
	End Method
	
	Field _vertice:Vector2 = Vector2.Zero() 
	Field _localVertice:Vector2 = Vector2.Zero() 
	Method _Update() 

		For Local i:Int = 0 To _localVertices.Count() - 1
			'#region INLINE:worldVertices[i] = Vector2.TransformRef(localVertices[i] , matrix) 
			_localVertice = _localVertices._vecArray[i] 
			Local num2:Float = ((_localVertice.X * _matrix.M11) + (_localVertice.Y * _matrix.M21)) + _matrix.M41
			Local num:Float = ((_localVertice.X * _matrix.M12) + (_localVertice.Y * _matrix.M22)) + _matrix.M42
			_vertice.X = num2
			_vertice.Y = num
			_worldVertices._vecArray[i].X = _vertice.X
			_worldVertices._vecArray[i].Y = _vertice.Y
			'#endregion
		Next
		_aabb.Update(_worldVertices) 
	End Method
	
	rem
	bbdoc: this handles the collision even for this geometry.
	it returns false if the user has cancelled the collision.
	since multiple objects can listen for this event, the decision
	to cancel is based on a logical 'or' of all the listener's return values.
	So if 1 object maintains that the collision should happen then it will.
	end rem
	Method OnCollision:Int(geometry1:TGeom, geometry2:TGeom, contactlist:TContactList)
		Local continueCollision:Int = False
		If _collisionEventListeners.IsEmpty() Then Return True
		For Local o:Object = EachIn _collisionEventListeners
			' this message should return null if the user wants to cancel the collision. otherwise a non-null return value indicates the user wants
			' the collision to happen.
			Local ret:Object = o.SendMessage(Self, TCollisionEventArgs.Create(geometry1, geometry2, contactlist, False))
			continueCollision = continueCollision Or (ret <> Null)
		Next
		Return continueCollision
	End Method
	
	rem
	bbdoc: this is called whenever two geometries are no longer
	colliding for the first time. This happens when the arbiter
	that handles these two geometries is being released by the
	physics engine. The contactList will be null and isExiting = true
	end rem
	Method OnCollisionExit(geometry1:TGeom, geometry2:TGeom)
		If _collisionEventListeners.IsEmpty() Then Return
		For Local o:Object = EachIn _collisionEventListeners
			' this message should return null if the user wants to cancel the collision. otherwise a non-null return value indicates the user wants
			' the collision to happen.
			o.SendMessage(Self, TCollisionEventArgs.Create(geometry1, geometry2, Null, True))
		Next
	End Method
	
	Method AddCollisionEventListener(listener:Object)
		_collisioneventListeners.AddLast(listener)
	End Method
	
	Method ClearListeners()
		_collisioneventListeners.Clear()
	End Method
	
	Method Equals:Int(o:Object) 
		If TGeom(o) Then
			Return TGeom(o) = Self
		End If
		Return False
	End Method
	
	Function LessThan:Int(geometry1:TGeom, geometry2:TGeom) 
		Return geometry1._id < geometry2._id
	End Function
	
	Function MoreThan:Int(geometry1:TGeom, geometry2:TGeom)
		Return geometry1._id > geometry2._id
	End Function
	
End Type

'handlers
Private

Type TGeomBodyListener Extends TBodyEventListener
	Field _geom:TGeom
	
	Function Create:TGeomBodyListener(geom:TGeom) 
		Local g:TGeomBodyListener = New TGeomBodyListener
		g._geom = geom
		Return g
	End Function
	
	Method BodyChanged(position:Vector2, rotation:Float) 
		_geom._Update2(position, rotation) 
	End Method
End Type
Public