
rem
Represents a lists of extents For a given axis.This list will be kept
sorted incrementally.
end rem
Type TExtentList Extends IList
	
	Field _owner:TSweepAndPruneCollider
	
	Function Create:TExtentList(sap:TSweepAndPruneCollider)
		Local el:TExtentList = New TExtentList
		el._owner = sap
		Return el
	End Function
	
	rem
	Inserts a new Extent into the already sorted list. As the ExtentList
	class is currently derived from the generic List class, insertions
	of new geometry (and extents) are going to be somewhat slow right
	off the bat. Additionally, this function currently performs 
	linear insertion. Two big optimizations in the future would be to
	(1) make this function perform a binary search and (2) allow for
	a "hint" of what index to start with. The reason for this is because
	there is always a min and max extents that need inserting and we
	know the max extent is always after the min extent.
	end rem
	Method InsertIntoSortedList:Int(newExtent:TExtent)
		rem
		List<> is not the most speedy for insertion, however, since
		we don't plan to do this except for when geometry is added
		to the system, we go ahead an use List<> instead of LinkedList<>
		This code, btw, assumes the list is already sorted and that
		the new entry just needs to be inserted.
		
		Optimization Note: A binary search could be used here and would
		improve speed for when adding geometry.
		
		Blitzmax note: Blitzmax uses a Linkedlist implementation for it's List datastructure.
		This has been taken into account for the port and the code has been modified
		to take advantage of this fact.
		end rem
		Local insertAt:Int = 0
		Local insertAfterLink:TLink = Null
		
		If _list.IsEmpty() Then
			Self.Add(newExtent)
			Return 0
		End If
		
		Local node:TLink = _list.FirstLink()
		insertAfterLink = _list.FirstLink()
		While node <> Null
			Local extent:TExtent = TExtent(node.Value())
			If extent._value < newExtent._value Or (extent._value = newExtent._value And extent._isMin And Not(newExtent._isMin)) Then
				insertAt:+1
				insertAfterLink = node
			Else
				Exit
			End If
			node = node.NextLink()
		Wend
		_list.InsertBeforeLink(newExtent, insertAfterLink)
		Return insertAt
	End Method
	
	rem
	Incrementally inserts the min/max extents into the ExtentList. As it
	does so, the method ensures that overlap records, the collisionpair
	map, and all other book-keeping is up todate.
	end rem
	Method IncrementalInsertExtent(ourInfo:TExtentInfo)
		Local mine:TExtent = ourInfo._min
		Local maxe:TExtent = ourInfo._max
		
		Assert mine._value < maxe._value, "extent values not sorted"

		Local imin:Int = InsertIntoSortedList(mine)
		Local imax:Int = InsertIntoSortedList(maxe)
		If _list.Count() = 34 Then
			'DebugStop
		End If
		Local ourGeom:TGeom = ourinfo._geometry
		
		'as this is a newly inserted extent, we need to update the overlap information
		
		'RULE 1: Traverse from min to max. Look for the other "min" Extends
		' and when found, add our wrapper/geometry to their list
		Local iCurr:Int = imin + 1
		Local curNode:TLink = _list.FindLink(_list.ValueAtIndex(iCurr)) ' a double look-up is not ideal :(
		
		While iCurr <> imax
			Local eInfo:TExtent = TExtent(curNode.Value())
			If eInfo._isMin Then
				eInfo._info._underConsideration.AddLast(ourgeom)
			End If
			curNode = curNode.NextLink()
			iCurr:+1
		Wend
		
		'RULE 2: From min, traverse to the left until we encounter
		' another 'min' extent. If we find one, we add its geometry
		' to our underconsideration list and go to RULE 3, otherwise
		' there is no more work to do and we can exit.
		iCurr = iMin - 1
		If iCurr >= 0 Then
			curNode = _list.FindLink(_list.ValueAtIndex(iCurr)) ' a double look-up is not ideal :(		
			While iCurr >= 0 And TExtent(curNode.Value())._isMin = False
				iCurr:-1
				curNode = curnode.PrevLink()
			Wend
		End If
		If iCurr < 0 Then
			Return
		End If
		
		Local ourUnderConsideration:TList = ourInfo._underConsideration
		Local currExtent:TExtent = TExtent(curNode.Value())
		
		ourUnderConsideration.AddLast(currExtent._info._geometry)
		
		'RULE 3: Now that we have found a 'min' extent, we take
		' its existing overlap list and copy it into our underConsideration
		' list. All except for ourselves.
		For Local otherExtents:TGeom = EachIn currExtent._info._underConsideration
			ourUnderConsideration.AddLast(otherExtents)
		Next
		ourUnderConsideration.Remove(ourgeom)	' just in case
		
		'RULE 4: move from the found extent back toward our 'min' extent.
		' whenever a 'max' extent is found, we remove its reference
		' from our extents list.
		curNode = _list.FindLink(_list.ValueAtIndex(iCurr))	' double look-up
		While iCurr <> iMin
			If currExtent._isMin = False Then
				ourUnderConsideration.Remove(currExtent._info._geometry)
				
				If ourinfo._overlaps.Remove(currExtent._info._geometry) Then
					_owner._collisionPairs.RemovePair(ourGeom, currExtent._info._geometry)
				End If
			End If
			iCurr:+1
			curNode = curNode.NextLink()
			currExtent = TExtent(curNode.Value())
		WEnd
	End Method
	
	Method Sort()
		_list.Sort(True, CompareExtents) 'mmm...bubble sort, not fast.
	End Method
	
	Function CompareExtents:Int(o1:Object, o2:Object)
		Local e1:TExtent = TExtent(o1)
		Local e2:TExtent = TExtent(o2)
		Return e1._value - e2._value
	End Function
	rem
	Incrementally sorts ExtentList.It is assumed that there is a high level
	of frame coherence and that much of the list is already fairly well
	sorted. This algorithm makes use of "insert sort" which is notoriously
	slow - except for when a list is already almost sorted - which is the
	case when there is high frame coherence.
	end rem
	Method IncrementalSort()
		If Count() < 2 Then
			Return
		End If
		
		'Bmax note: could be implemented much faster using arrays and array concatenation but for simplicity
		' used LinkedLists.
		For Local i:Int = 0 To Count() - 2
			Local evalCnt:Int = i + 1
			Local evalExtent:TExtent = TExtent(_list.ValueAtIndex(evalCnt))
			Local currExtent:TExtent = TExtent(_list.ValueAtIndex(i))
			
			If currExtent._value <= evalExtent._value Then
				Continue
			End If
			
			Local savedExtent:TExtent = evalExtent
			
			If evalExtent._isMin Then
				While currExtent._value > evalExtent._value
					If currExtent._isMin Then
						rem
						Begin extent is inserted before another begin extent.
						So, Inserted extent's object looses reference to
						non-inserted extent and Non-inserted extent gains 
						reference to inserted extent's object.
						end rem
						evalExtent._info._underConsideration.Remove(currExtent._info._geometry)
						
						If evalExtent._info._overlaps.Remove(currExtent._info._geometry) Then
							_owner._collisionPairs.RemovePair(evalExtent._info._geometry, currExtent._info._geometry)
						End If
						
						' add extent
						currExtent._info._underConsideration.AddLast(evalExtent._info._geometry)
					Else
						' min extent inserted before max extent
						' inserted extent gains reference to non-inserted extent
						evalExtent._info._underConsideration.AddLast(currExtent._info._geometry)
					End If
					
					Local evalValue:TLink = _list.FindLink(_list.ValueAtIndex(evalCnt))
					evalValue._value = currExtent
					evalCnt:-1
					i:-1
					If i < 0 Then Exit
					currExtent = TExtent(_list.ValueAtIndex(i))
				Wend
			Else
				While currExtent._value > evalExtent._value
					If currExtent._isMin Then
						rem
						Ending extent inserted before a beginning extent
						the non inserted extent looses a reference to the
						inserted one
						end rem
						currExtent._info._underConsideration.Remove(evalExtent._info._geometry)
						
						If currExtent._info._overlaps.Remove(evalExtent._info._geometry) Then
							_owner._collisionPairs.RemovePair(evalExtent._info._geometry, currExtent._info._geometry)
						End If
					End If
					Local evalValue:TLink = _list.FindLink(_list.ValueAtIndex(evalCnt))
					evalvalue._value = currExtent
					evalCnt:-1
					i:-1
					If i < 0 Then Exit
					currExtent = TExtent(_list.ValueAtIndex(i))
				WEnd
			End If
			Local evalLink:TLink = _list.FindLink(_list.ValueAtIndex(evalCnt))
			evalLink._value = savedExtent
		Next
	End Method
End Type
