
'This class keeps a list of information that relates extents to geometries.
Type TExtentInfoList Extends IList

	Field _owner:TSweepAndPruneCollider
	
	Function Create:TExtentInfoList(sap:TSweepAndPruneCollider)
		Local ei:TExtentInfoList = New TExtentInfoList
		ei._owner = sap
		Return ei
	End Function
	
	Method MoveUnderConsiderationToOverlaps()
		
		For Local ei:TExtentInfo = EachIn Self
			If ei._underConsideration.IsEmpty() Then
				Continue
			End If
			
			Local g1:TGeom = ei._geometry
		'	Local aabb1:TAABB = g1._aabb
			
			' first transfer those under consideration to overlaps
			' for, they have been considered
			Local startIndex:Int = ei._overlaps.Count()
			For Local consideredGeoms:TGeom = EachIn ei._underConsideration
				ei._overlaps.AddLast(consideredGeoms)
			Next
			ei._underConsideration.Clear()
			For Local j:Int = startIndex To ei._overlaps.Count() - 1
				Local g2:TGeom = TGeom(ei._overlaps.ValueAtIndex(j))
				
				rem
				It is possible that we may test the same pair of geometries
				for both extents (x and y), however, I'm banking on that
				one of the extents has probably already been cached and
				therefore, won't be checked.
				end rem
				If TSweepAndPruneCollider.DoCollision(g1, g2) = False Then
					Continue
				End If
				_owner._collisionPairs.AddPair(g1, g2)
			Next
		Next
	End Method
End Type
