
Type TContactList Extends IList


	Method IndexOfSafe:Int(contact:TContact) 
		Local index:Int = -1
		Local i:Int = 0
		For Local c:TContact = EachIn Self
			If c.Equals(contact) Then
				index = i
				Exit
			End If
			i:+1
		Next
		Return index		
	End Method
	
	Method Sort() 
		Self._list.Sort(True, CompareSeparation) 
	End Method
	
	Method RemoveRange(index:Int, count:Int, _contactPool:TContactPool) 
		Local removeList:TList = CreateList() 
		For Local i:Int = index To index + count - 1
			removeList.addlast(_list.ValueAtIndex(i)) 			
		Next
		For Local o:Object = EachIn removeList
			_list.remove(o) 
			_contactPool.Free(o) 
		Next
	End Method
	
	Function CompareSeparation:Int(o1:Object, o2:Object) 
		Local c1:TContact = TContact(o1) 
		Local c2:TContact = TContact(o2) 
		If c1.Seperation < c2.Seperation Then
			Return - 1
		Else If c1.Seperation = c2.Seperation
			Return 0
		Else
			Return 1
		End If
	End Function
End Type
