
rem
This class is used to keep track of the pairs of geometry that need to be
passed on to the narrow phase. The keys stored in the dictionary are
the actual geometry pairs (the boolean value is currently unused).
NOTE: May eventually want to add OnEnterCollisionState / 
OnExitCollisionState callbacks which might be useful for debugging
or possibly in user applications.
end rem
Type TCollisionPairDictionary
	Field _map:TMap
	
	Method New()
		_map = CreateMap()		
	End Method
	
	Method RemovePair(g1:TGeom, g2:TGeom)
		Local cp:TCollisionPair = TCollisionPair.Create(g1, g2)
		_map.Remove(cp)
		
		rem
		May want a OnDeactivatedCollision here.
		For example, if you were highlighting colliding
		ABV's for debugging, this callback would let you
		know to stop.
		end rem
	End Method
	
	Method AddPair(g1:TGeom, g2:TGeom)
		Local cp:TCollisionPair = TCollisionPair.Create(g1, g2)
		
		rem
		This check is a trade-off. In many cases, we don't need to perform
		this check and we could just do a "try" block instead, however,
		when exceptions are thrown, they are mega-slow... so checking for
		the key is really the best option all round.
		end rem
		If _map.Contains(cp) Then
			Return
		End If
		_map.Insert(cp, Null)
	End Method
	
	Method Keys:TMapEnumerator()
		Return _map.Keys()
	End Method
	
	Method Clear()
		_map.Clear()
	End Method
End Type
