Type TBruteForceCollider Extends IBroadPhaseCollider

	Field _physicsSimulator:TPhysicsSimulator
	
	Function Create:TBruteForceCollider(physics:TPhysicsSimulator)
		Local brute:TBruteForceCollider = New TBruteForceCollider
		brute._physicsSimulator = physics
		Return brute
	End Function
	
	Method Add(geom:TGeom)
		' no need.
	End Method
	
	Method ProcessRemovedGeoms()
		' not required
	End Method
	
	Method Update()
		DoCollision()
	End Method
	
	Field _geometryA:TGeom
	Field _geometryB:TGeom
	Field _arbiter:TArbiter
	Field _geomList:TGeom[]
	Method DoCollision()
		Local geomLista:TGeomList = _physicsSImulator.GetGeomList()
		_geomList = New TGeom[geomlista.Count()]
		' must be a faster way to do this.
		For Local i:Int = 0 To _geomList.length - 1
			_geomList[i] = TGeom(geomlista.AtIndex(i))
		Next
		
		For Local i:Int = 0 To _geomList.Length - 1
			For Local j:Int = i + 1 To _geomList.Length - 1
				_geometryA = _geomList[i]
				_geometryB = _geomList[j]
				
				'possible early exits
				If Not(_geometryA._body._enabled) Or Not(_geometryB._body._enabled) Then
					Continue
				End If
				
				If (_geometryA._collisionGroup = _geometryB._collisionGroup) And _geometryA._collisionGroup <> 0 And _geometryB._collisionGroup <> 0 Then
					Continue
				End If
				
				If Not(_geometryA._collisionEnabled) Or Not(_geometryB._collisionEnabled) Then
					Continue
				End If
				
				If (_geometryA._body._isStatic And _geometryB._body._isStatic) Then 'don't collide two static bodies
					Continue
				End If
				
				If (_geometryA._body = _geometryB._body) Then ' don't collide two geometiers from same body
					Continue
				End If
				
				If ((_geometryA._collisionCategories & _geometryB._collidesWith) = CollisionCategories.None) & ((_geometryB._collisionCategories & _geometryA._collidesWith) = CollisionCategories.None) Then
					Continue
				End If
				
				Local intersection:Int = True
				
				'#Region INLINE: INLINE: if (AABB.Intersect(geometryA.aabb, geometryB.aabb)) ....
				If _geometryA._aabb._min.X > _geometryB._aabb._max.X Or _geometryB._aabb._min.X > _geometryA._aabb._max.X Then
					intersection = False
				Else If _geometryA._aabb._min.Y > _geometryB._aabb._max.Y Or _geometryB._aabb._min.Y > _geometryA._aabb._max.Y Then
					intersection = False
				End If
				'#End Region
				
				If intersection Then
					_arbiter = TArbiter(_physicsSimulator._arbiterPool.Fetch())
					_arbiter.ConstructArbiter(_geometryA, _geometryB, _physicsSimulator)
					
					If Not(_physicsSimulator._arbiterList.Contains(_arbiter)) Then
						_physicsSimulator._arbiterList.Add(_arbiter)
					Else
						_physicsSimulator._arbiterPool.Free(_arbiter)
					End If
				End If
			Next
		Next
	End Method
End Type
