
Type TAABB

	Field _epsilon:Float = 0.00001
	Field _min:Vector2 = Vector2.Zero() 
	Field _max:Vector2 = Vector2.Zero() 	
	
'#Region Properties
	Method GetMin:Vector2() 
		Return _min.Copy() 
	End Method
	
	Method GetMax:Vector2() 
		Return _max.Copy() 
	End Method
	
	Method GetWidth:Float() 
		Return _max.X - _min.X
	End Method
	
	Method GetHeight:Float() 
		Return _max.Y - _min.Y
	End Method
	
	Method GetVertices:TVertices() 
		Local vertices:TVertices = New TVertices
		vertices.add(GetMin()) 
		vertices.add(Vector2.Create(_min.X, _max.Y)) 
		vertices.add(GetMax()) 
		vertices.add(Vector2.Create(_max.X, _min.Y)) 
		Return vertices
	End Method
	
	Method GetCenter:Vector2() 
		Return Vector2.Create(_min.X + (_max.X - _min.X) / 2, _min.Y + (_max.Y - _min.Y) / 2) 
	End Method
	
	Method GetShortestSide:Float() 
		Local width:Float = _max.X - _min.X
		Local height:Float = _max.Y - _min.Y
		Return Min(width, height) 
	End Method
'#End Region 

'#Region Constructors
	Method New() 
		
	End Method
	
	Function Create:TAABB(minv:Vector2, maxv:Vector2) 
		Local aabb:TAABB = New TAABB
		aabb._max = maxv.Copy() 
		aabb._min = minv.Copy() 
		Return aabb
	End Function
	
	Function CreateFromAABB:TAABB(aabb:TAABB) 
		Local box:TAABB = New TAABB
		box._min.X = aabb._min.X
		box._min.Y = aabb._min.Y
		box._max.X = aabb._max.X
		box._max.Y = aabb._max.Y
		Return box
	End Function
	
	Function CreateFromVertices:TAABB(vertices:TVertices) 
		Local aabb:TAABB = New TAABB
		aabb.Update(vertices) 
		Return aabb
	End Function
'#End Region 

	Field _vertice:Vector2 = Vector2.Zero() 
	Method Update(vertices:TVertices) 
		_min.X = vertices._vecArray[0].X
		_min.Y = vertices._vecArray[0].Y
		_max.X = _min.X
		_max.Y = _min.Y
		
		For Local i:Int = 0 To vertices.Count() - 1
			_vertice = vertices._vecArray[i] 
			If (_vertice.X < _min.X) Then _min.X = _vertice.X
			If (_vertice.X > _max.X) Then _max.X = _vertice.X
			If (_vertice.Y < _min.Y) Then _min.Y = _vertice.Y
			If (_vertice.Y > _max.Y) Then _max.Y = _vertice.Y
		Next

	End Method
	
	Method Contains:Int(point:Vector2) 
		'using epsilon to try and gaurd against float rounding errors.
		If ((point.X > (_min.X + _epsilon) And point.X < (_max.X - _epsilon) And (point.Y > (_min.Y + _epsilon) And point.Y < (_max.Y - _epsilon)))) Then
			Return True
		Else
			Return False
		End If
	End Method
	
	Function Intersect:Int(aabb1:TAABB, aabb2:TAABB) 
		If (aabb1._min.X > aabb2._max.X Or aabb2._min.X > aabb1._max.X) Then
			Return False
		Else If (aabb1._min.Y > aabb2._max.Y Or aabb2._min.Y > aabb1._max.Y) Then
			Return False
		End If
		Return True
	End Function
	
	Method ToString:String() 
		Return "min: " + _min.ToString() + " || max: " + _max.ToString() 
	End Method
End Type
