
Global Game:TDemo = Null
Type TDemo

	Global _running:Int = True
	Global gfxWidth:Int = 1024
	Global gfxHeight:Int = 768
	Field _fpsCount:Int
	Field _frameRate:Int
	Field _msElapse:Int
	
	' delta timing variables
	Field _accumulator:Float
	Field _currentTime:Int
	Field _dt:Float = 1.0 / 60.0 'fps of game logic
	
	Method New() 
		Game = Self
	End Method
	
	Method Init() 
		AppTitle = "Farseer Physics Demos"
	'	SetGraphicsDriver(GLMax2DDriver ()) 
		Graphics(gfxWidth, gfxHeight, 0, 100)
		Vector2.InitVector2()
		ScreenManager.Instance().AddScreen(New MainMenuScreen) 
		SetClsColor(64, 156, 233) 
		SetBlend(ALPHABLEND)

	End Method
	
	Method Update(delta:Float)
		ScreenManager.Instance().Update(delta)
		Local ms:Int = MilliSecs() 
		If ms - _msElapse > 1000 Then
			_frameRate = _fpsCount
			_fpsCount = 0
			_msElapse = ms
		End If
	End Method
	
	Method Draw() 
		Cls
			ScreenManager.Instance().Draw(_dt)
			DrawText("fps: " + _frameRate, 50, 50) 
			_fpsCount:+1
		Flip() 
	End Method
	
	Function Quit() 
		_running = False
	End Function
	
	Method Run()
		_currentTime = MilliSecs()	
		While _running
			Local realTime:Int = MilliSecs()
			Local deltaTime:Float = (realTime - _currentTime) * 0.001 ' delta converted to seconds
			deltaTime = MathHelper.Clamp(deltaTime, 0, 1)
			_currentTime = realTime
			_accumulator:+deltaTime
			While _accumulator > _dt
				Update(0.01)
				_accumulator = _accumulator - _dt
			Wend 
			Draw()
		Wend
	End Method
End Type

Function RunGame() 
	Local game:TDemo = New TDemo
	game.Init() 	
	game.Run() 
End Function


