'This BMX file was edited with BLIde ( http://www.blide.org )

Type ScreenManager
	Global _instance:ScreenManager
	
	Field _curScreen:TScreen
	Field _screens:TList = CreateList() 
	Field _input:TInput

	Method New()
		_input = New TInput
	End Method
	
	Function Instance:ScreenManager() 
		If _instance = Null Then
			_instance = New ScreenManager
		End If
		Return _instance
	End Function
	
	Method GetInput:TInput()
		Return _input
	End Method
	
	Method Update(delta:Float) 
		Local escape:Int = KeyHit(KEY_ESCAPE)
		_input.Update()
		Local revList:TList = _screens.Reversed()
		Local covered:Int = False
		For Local screen:TScreen = EachIn revlist
			screen.SetCovered(covered)
			screen.Update(delta) 
			If escape Then
				screen.OnEscapeKeyHit()
			End If
			If Not screen.IsPopUp() Then
				Exit
			End If
			covered = True
		Next
	'	_curscreen.Update(delta) 
	End Method
	
	Method Draw(delta:Float)
		For Local screen:TScreen = EachIn _screens
			screen.Draw(delta)
		Next
		'_curScreen.Draw(delta)
	End Method
	
		
	Method AddScreen(screen:TScreen) 
		screen.Load() 
		_screens.AddLast(screen) 
	End Method
	
	Method RemoveScreen(screen:TScreen) 
		screen.Unload() 
		_screens.Remove(screen) 
	End Method
	
	
	Method RemoveAll() 
		For Local screen:TScreen = EachIn _screens
			screen.Unload() 
		Next		
		_screens.Clear() 
	End Method
	
'	Method SwitchScreen(screen:TScreen) 
'		If _curScreen = Null Then
'			_curScreen = screen
'		Else
'			_curScreen.Unload() 
'			_curScreen = screen
'		End If
'
'		_curScreen.Load() 
'	End Method
End Type
