
' demo screens
Type TScreen Abstract

	Field lineBrush:TLineBrush = TLineBrush.Create(1, TColor.Black)
	Field lastMouseDown:Int
	Field currentMouseDown:Int
	Field mousePickSpring:TFixedLinearSpring
	Field physics:TPhysicsSimulator
	Field view:TPhysicsSimulatorView
	Field covered:Int = False
	
	Field _isPopup:Int
	
	Method IsPopUp:Int() 
		Return _isPopUp
	End Method
	
	Method SetPopUp(value:Int) 
		_isPopUp = value
	End Method
	
	Method SetCovered(value:Int)
		covered = value
	End Method
	
	Method GetCovered:Int()
		Return covered
	End Method
	
	Method ExitScreen() 
		ScreenManager.Instance().RemoveScreen(Self) 
	End Method
	
	Method OnEscapeKeyHit() 
		Self.ExitScreen() 
	End Method
	
	Method DrawMouseSpring()
		If mousePickSpring <> Null Then
			lineBrush.Draw(mousePickSpring._body.GetWorldPosition(mousePickSpring.GetBodyAttachPoint()), mousePickSPring.GetWorldAttachPoint())
		End If
	End Method
	
	Method HandleMouseInput()
		Local point:Vector2 = Vector2.Create(MouseX(), MouseY())
		currentMouseDown = ScreenManager.Instance().GetInput().CurrentLeftMouse' MouseDown(1)
		If (lastMouseDown = False And currentMouseDown = True) Then 'clicked
			Local pickedGeom:TGeom = physics.Collide(point)
			If pickedGeom <> Null Then
				mousePickSpring = TControllerFactory.CreateFixedLinearSpring(physics, pickedGeom.GetBody(), pickedGeom.GetBody().GetLocalPosition(point), point, 20, 10)
			End If
		Else If (lastMouseDown = True And currentMouseDown = False) Then 'released
			If mousePickSpring <> Null Then
				physics.RemoveController(mousePickSpring)
				mousePickSpring = Null
			End If
		End If
	
		If currentMouseDown = True And mousePIckSpring <> Null Then
			mousePickSpring.SetWorldAttachPoint(point)
		End If
		lastMouseDown = currentMouseDown
	End Method
	
	Method Load() Abstract
	Method Unload() Abstract
	Method Update(delta:Float) Abstract
	Method Draw(delta:Float) Abstract		


End Type
