
Type MainMenuScreen Extends TScreen

	Field _entriesList:TList
	Field _bg:TImage
	Field _bmax:TImage
	Field about:TScreen
	Method New() 
		
	End Method
	
	Method Draw(delta:Float)
		SetOrigin(0, 0)
		SetColor(255, 255, 255)
		DrawRect(0, 0, TDemo.gfxWidth, TDemo.gfxHeight)
		DrawImage(_bg, TDemo.gfxWidth / 2 + 100, TDemo.gfxHeight / 2)
		DrawImage(_bmax, TDemo.gfxWidth -_bmax.width, TDemo.gfxHeight -_bmax.height)
		SetColor(0, 0, 0)
		DrawText("Demos", 100, 210)
		For Local me:MenuEntry = EachIn _entriesList
			me.Draw() 
		Next
		SetColor(0, 0, 0)
		DrawText ("Toggle between Debug and normal view by pressing F1", 100, 700)
		DrawText("Click on a demo to view it", 100, 720)
		SetColor(255, 255, 255)
	End Method
			
	Method Update(delta:Float) 
		Local mhit:Int = ScreenManager.Instance().GetInput().CurrentMouseLeftHit' MouseHit(1) 
		For Local me:MenuEntry = EachIn _entriesList
			me.Update(mhit) 
			If me.WasClicked() Then
				LoadDemo(me) 
			End If
		Next
		
		If KeyHit(KEY_F3) Then
			ScreenManager.Instance().AddScreen(New TDemoTestScreen)
			Self.ExitScreen()
		End If
	End Method
	
	Method OnEscapeKeyHit() 
		TDemo.Quit() 
	End Method
	
	Method Load() 
		Local x:Float = 100
		Local y:Float = 240
		_entriesList = CreateList() 
		_entriesList.AddLast(MenuEntry.Create(1, "   1 - Basic Geometry", x, y))
		y:+30
		_entriesList.AddLast(MenuEntry.Create(2, "   2 - Rigid Body Collisions", x, y))
		y:+30
		_entriesList.AddLast(MenuEntry.Create(3, "   3 - Static Bodies and offset geometries", x, y))
		y:+30
		_entriesList.AddLast(MenuEntry.Create(4, "   4 - Stacked Bodies", x, y))
		y:+30
		_entriesList.AddLast(MenuEntry.Create(5, "   5 - Collision Categories", x, y))
		y:+30
		_entriesList.AddLast(MenuEntry.Create(6, "   6 - Linear and Angular Springs", x, y))
		y:+30
		_entriesList.AddLast(MenuEntry.Create(7, "   7 - Dynamic Angle Joints", x, y))
		y:+30
		_entriesList.AddLast(MenuEntry.Create(8, "   8 - Broad Phase Collision Stress Test", x, y))
		y:+30
		_entriesList.AddLast(MenuEntry.Create(9, "   9 - Concave Polygon Collision", x, y))
		y:+30
		_entriesList.AddLast(MenuEntry.Create(10, "   10 - Angle Limit Joints", x, y))
		y:+30
		_entriesLIst.AddLast(MenuEntry.Create(11, "   11 - Pin and Slider Joints", x, y))
		y:+30
		_entriesList.AddLast(MenuEntry.Create(12, "   12 - Fluid Drag Controller", x, y))
		y:+30
		_entriesList.AddLast(MenuEntry.Create(13, "   13 - Collision Event Handling", x, y))
		y:+30
		_entriesList.AddLast(MenuEntry.Create(14, "About", x, y))
		y:+30
		_entriesList.AddLast(MenuEntry.Create(15, "Quit", x, y))
		
		_bg = LoadImage("incbin::images/logo.png")
		MidHandleImage(_bg)
		_bmax = LoadImage("incbin::images/B-Max.png")
	End Method
	
	
	Method LoadDemo(me:MenuEntry) 
		Select me.GetId() 		
		Case 1 ' basic geometry
			ScreenManager.Instance().AddScreen(New Demo1Screen) 
		Case 2 ' two bodies with geom
			ScreenManager.Instance().AddScreen(New Demo2Screen) 
		Case 3 ' static bodies with offset geom
			ScreenManager.Instance().AddScreen(New Demo3Screen) 
		Case 4 ' stacked bodies
			ScreenManager.Instance().AddScreen(New Demo4Screen) 
		Case 5 ' collision categories
			ScreenManager.Instance().AddScreen(New Demo5Screen)
		Case 6 ' linear and angular springs
			ScreenManager.Instance().AddScreen(New Demo6Screen)
		Case 7 ' dynamic angle joints
			ScreenManager.Instance().AddScreen(New Demo7Screen)
		Case 8 ' broadphase stress test
			ScreenManager.Instance().AddScreen(New Demo8Screen)
		Case 9 ' concave polys
			ScreenManager.Instance().AddScreen(New Demo9Screen)
		Case 10 ' angle limits
			ScreenManager.Instance().AddScreen(New Demo10Screen)
		Case 11 ' pin and slider joints
			ScreenManager.Instance().AddScreen(New Demo11Screen)
		Case 12 ' fluid drag controller
			ScreenManager.Instance().AddScreen(New Demo12Screen)
		Case 13 ' collision event handling
			ScreenManager.Instance().AddScreen(New Demo13Screen)
		Case 14 ' about screen
			If Not Self.GetCovered() Then
				about = New AboutScreen
				ScreenManager.Instance().AddScreen(about)
			End If
			Return
		Case 15 ' quit
			TDemo.Quit() 
		End Select
		If about <> Null Then
			about.ExitScreen()
		End If
		
		Self.ExitScreen()
	End Method
	
	Method Unload() 
		
	End Method

End Type


