
Type AboutScreen extends TScreen
	
	Field _blackShade:TColor = TColor.Create(130, 0, 0, 0)
	Field _height:Float = 0
	Field _time:Float
	Field _close:MenuEntry
	
	Method Draw(delta:Float)
		_blackShade.Set()
		Local y:Float = 150 - _height / 2
		DrawRect(0, y, TDemo.gfxWidth, _height)
		_blackShade.Reset()
		If _time >= 1 Then
			SetColor(255, 255, 255)
			DrawText ("About", TDemo.gfxWidth / 2 - TextWidth("About") / 2, 110)
			Local jeff:String = "Original Farseer Physics Engine written by Jeff Weber [http://www.farseergames.com]"
			Local alex:String = "Ported to Blitzmax by Alex Okafor [http://www.paradeofrain.com]"
			DrawText(jeff, TDemo.gfxWidth / 2 - TextWidth(jeff) / 2, 130)
			DrawText(alex, TDemo.gfxWidth / 2 - TextWidth(alex) / 2, 150)
			_close.Draw()
		End If
	End Method
	
	Method Update(delta:Float)
		_time:+delta*2
		_time = MathHelper.Clamp(_time, 0, 1)
		_height = MathHelper.SmoothStep(0, 100, _time)
		_close.Update(ScreenManager.Instance().GetInput().CurrentMouseLeftHit)
		If _close.WasClicked() Then
			self.ExitScreen()
		End If
		
	End Method
	
	Method Unload()
		
	End Method
	
	Method Load()
		_close = MenuEntry.Create(0, "Close", TDemo.gfxWidth / 2 - TextWidth("Close") / 2, 175)
		self.SetPopUp(true)
	End Method
	
End Type
