SuperStrict
Import "DemoLib.bmx"

' setup our graphics device and render settings
Graphics 800,600
SetClsColor(64,156,233)
SetBlend(ALPHABLEND)

' create an instance of the physics engine
' and the physics engine viewer so we can see our objects.
Global physics:TPhysicsSimulator
Global viewer:TPhysicsSimulatorView

' setup our physics with a gravity of 100 and initialize the viewer
physics = TPhysicsSimulator.Create(Vector2.Create(0,100))
viewer = TPhysicsSimulatorView.Create(physics)
physics.EnableDiagnostics = True	' with this true the engine will calculate timing information for benchmarking


' create a basic box body with a mass of 1 and a geometry to match it.
Global body:TBody = TBodyFactory.CreateRectangleBody(physics, 100, 100, 1)
TGeomFactory.createRectangleGeom(physics, body, 100, 100)
body.SetPosition(Vector2.Create(400,300)) ' then put it at the center of the screen


' create a floor so our body just doesn't fall off the screen.
Local floorBody:TBody = TBodyFactory.CreateRectangleBody(physics,800,200,1)
TGeomFactory.CreateRectangleGeom(physics, floorBody, 800, 200)

'position our floor
floorBody.SetPosition(Vector2.Create(400,500))
' set it to static so the floor has an 'infinite mass' and doesn't budge.
floorBody.SetStatic(True) 

' a basic update/draw loop
While Not(KeyHit(KEY_ESCAPE))

	Update()
	Cls
	Draw()
	Flip
Wend


Function Update()
	' update our physics engine
	' with a given time step.
	physics.Update(.01)
	
	' some controls to move our body 
	' to make things interesting :)
	Local force:Vector2 = Vector2.Zero()
	Local speed:Float = 1000
	If KeyDown(KEY_UP) Then
		force.Y = -speed
	End If
	If KeyDown(KEY_DOWN) Then
		force.Y:+speed
	End If
	If KeyDown(KEY_LEFT) Then
		force.X:-speed
	End If
	If KeyDown(KEY_RIGHT) Then
		force.X:+speed
	End If
	body.ApplyForce(force)
	
	' apply a little torque
	body.ApplyTorque(900)
End Function

' just draw our viewer :D
Function Draw()
	viewer.Draw()
End Function