
Type TCircleBrush
	Field _borderColor:TColor
	Field _color:TColor
	Field _layer:Float
	Field _radius:Float
	Field _texture:TImage
	
	Method GetColor:TColor() 
		Return _color
	End Method
	
	Method SetColor(value:TColor) 
		_color = value
	End Method
	
	
	Method GetLayer:Float() 
		Return _layer
	End Method
	
	Method SetLayer(value:Float) 
		_layer = value
	End Method
	
	Method GetBorderColor:TColor() 
		Return _borderColor
	End Method
	
	Method SetBorderColor(value:TColor) 
		_borderColor = value.Copy() 
	End Method
	
	Function Create:TCircleBrush(radius:Float, color:TColor, borderColor:TColor) 
		Local c:TCircleBrush = New TCircleBrush
		c._borderColor = borderColor
		c._color = color
		c._radius = radius
		c._texture = TDrawingHelper.CreateCircleTexture(radius, color, borderColor) 
		MidHandleImage(c._texture) 
		Return c
	End Function
	
	Method Draw(position:Vector2) 
		DrawImage(_texture, position.X, position.Y) 
	End Method
End Type
