
Type TRectanglePlatform
	Field _texture:TImage
	
	Field _body:TBody
	Field _geom:TGeom
	
	Field _width:Int
	Field _height:Int
	Field _position:Vector2 = Vector2.Zero()
	Field _color:TColor
	Field _borderColor:TColor
	Field _collisionGroup:Int
	
	Function Create:TRectanglePlatform(width:Int, height:Int, position:Vector2, color:TColor, borderColor:TColor, collisiongroup:Int)
		Local r:TRectanglePlatform = New TRectanglePlatform
		r._width = width
		r._height = height
		r._position.Set(position)
		r._color = color.Copy()
		r._borderColor = borderColor.Copy()
		r._collisionGroup = collisiongroup
		Return r
	End Function
	
	
	Method Draw()
		DrawImage(_texture, _position.X, _position.Y)
	End Method
	
	Method Load(physics:TPhysicsSimulator)
		_texture = TDrawingHelper.CreateRectangleTexture(_width, _height, _color, _borderColor, 2, 0, 0)
		MidHandleImage(_texture)
			
		_body = TBodyFactory.CreateRectangleBody(physics, _width, _height, 1)
		_body.SetStatic(True)
		_body.SetPosition(_position)
		
		_geom = TGeomFactory.CreateRectangleGeom(physics, _body, _width, _height)
		_geom.SetCollisionGroup(_collisionGroup)
		_geom.SetFrictionCoefficient(1)
		_geom.SetRestitutionCoefficient(.2)
	End Method
End Type
