
Type TPolyBody
	Global colorIndex:Int = 0
	'rendering
	Field _color:TColor
	Field _img:TImage
	
	Field _vertices:Vector2[]
	Field _completed:Int
	Field _body:TBody
	Field _geom:TGeom
	
	Method New()
		Local colArray:TColor[] = New TColor[9]' done here for convience sake
		colArray[0] = TColor.Create(255, 234, 125, 19)
		colArray[1] = TColor.Create(255, 234, 255, 19)
		colArray[2] = TColor.Create(255, 234, 19, 192)
		colArray[3] = TColor.Create(255, 145, 234, 19)
		colArray[4] = TColor.Create(255, 108, 19, 234)
		colArray[5] = TColor.Create(255, 234, 19, 105)
		colArray[6] = TColor.Create(255, 96, 96, 96)
		colArray[7] = TColor.Create(255, 19, 234, 147)
		colArray[8] = TColor.Create(255, 255, 255, 255)		
		_color = colArray[colorIndex]
		colorindex:+1
		If colorindex >= colArray.Length Then
			colorIndex = 0
		End If
	End Method
	
	Function Create:TPolyBody()
		Local p:TPolyBody = New TPolyBody
		Return p
	End Function
	
	Method AddVertex(p:Vector2)
		_vertices = _vertices[.._vertices.Length + 1]
		_vertices[_vertices.Length - 1] = p.Copy()
	End Method
	
	Method Complete(physics:TPhysicsSimulator)
		_completed = True
		Local verts:TVertices = TVertices.Create(_vertices)
		Local area:Float = verts.GetArea()

		_body = TBodyFactory.CreatePolygonBody(physics, verts, area / 3000.0)
		_geom = TGeomFactory.CreatePolygonGeom(physics, _body, verts)
		If _geom._collisionGridCellSize > 10 Then
			_geom.SetCollisionGridCellSize(10)
		End If
		_img = TDrawingHelper.CreatePolygonTexture(_vertices, _color)
		MidHandleImage(_img)
	End Method
	
	Method Draw()
		If Not _completed Then
			For Local i:Int = 0 To _vertices.Length - 2
				Local p1:Vector2 = _vertices[i]
				Local p2:Vector2 = _vertices[NextIndex(i)]
				DrawLine(p1.X, p1.Y, p2.X, p2.Y)
			Next
		Else
			_DrawPhysicsObject()
		End If
	End Method
	
	Method _DrawPhysicsObject()
		_DrawGeom(_geom, _img)
		SetOrigin(0, 0)
		SetRotation(0)

	End Method
	
	Method _DrawGeom(geom:TGeom, texture:TImage)
		SetOrigin(geom._position.X, geom._position.Y)
		SetRotation(MathHelper.ToDegrees(geom.GetRotation()))
		DrawImage(texture, 0, 0)

	End Method
	
	Method NextIndex:Int(index:Int)
		If index = _vertices.Length - 1 Then
			Return 0
		Else
			Return index + 1
		End If
	End Method	

	
	Method Count:Int() 
		Return _vertices.Length
	End Method
	
	Method PreviousIndex:Int(index:Int) 
		If index = 0 Then
			Return _vertices.Length - 1
		Else
			Return index - 1
		End If
	End Method

End Type
