
Type TCircles
	Field _circleBrush:TCircleBrush
	Field _circleBody:TBody[]
	Field _circleGeom:TGeom[]
	
	Field _radius:Int = 100
	Field _color:TColor = TColor.White
	Field _borderColor:TColor = TColor.White
	
	Field _count:Int = 2
	Field _startPosition:Vector2 = Vector2.Zero()
	Field _endPosition:Vector2 = Vector2.Zero()
	
	Field _collisionCategories:Int = CollisionCategories.All
	Field _collidesWith:Int = CollisionCategories.All
	
	
	Method SetCollisionCategories(value:Int)
		_collisionCategories = value
	End Method
	
	Method GetCollisionCategories:Int()
		Return _collisionCategories
	End Method
	
	
	Method SetCollidesWith(value:Int)
		_collidesWith = value
	End Method
	
	Method GetCollidesWith:Int()
		Return _collidesWith
	End Method
	
	Function Create:TCircles(startPosition:Vector2, endPosition:Vector2, count:Int, radius:Int, color:TColor, borderColor:TColor)
		If count < 2 Then Throw "count must be 2 or greater"
		Local c:TCircles = New TCircles
		c._count = count
		c._radius = radius
		c._color = color.Copy()
		c._borderColor = borderColor.Copy()
		c._startPosition = startPosition.Copy()
		c._endPosition = endPosition.Copy()
		Return c
	End Function
	
	
	Method Draw()
		For Local i:Int = 0 To _count - 1
			_circleBrush.Draw(_circleGeom[i].GetPosition())
		Next
	End Method
	
	Method Load(physics:TPhysicsSimulator)			
		_circleBrush = TCircleBrush.Create(_radius, _color, _borderColor)
		
		_circleBody = New TBody[_count]
		_circleGeom = New TGeom[_count]
		
		_circleBody[0] = TBodyFactory.CreateCircleBody(physics, _radius, .5)
		_circleBody[0].SetPosition(_startPosition)
		For Local i:Int = 1 To _count - 1
			_circleBody[i] = TBodyFactory.CloneBody(physics, _circleBody[0])
			_circleBody[i].SetPosition(Vector2.Lerp(_startPosition, _endPosition, Float(i) / Float(_count - 1)))
		Next
		
		_circleGeom[0] = TGeomFactory.CreateCircleGeom(physics, _circleBody[0], _radius, 10)
		_circleGeom[0].SetRestitutionCoefficient(.7)
		_circleGeom[0].SetFrictionCoefficient(.2)
		_circleGeom[0].SetCollisionCategory(_collisionCategories)
		_circleGeom[0].SetCollidesWith(_collidesWith)
		For Local j:Int = 1 To _count - 1
			_circleGEom[j] = TGeomFactory.CloneGeom(physics, _circleBody[j], _circleGeom[0])
		Next
	End Method
	
End Type
