
Type TBorder

	Field _texture:TImage[]
	Field _body:TBody
	Field _geom:TGeom[]
	
	Field _width:Int
	Field _height:Int
	Field _borderWidth:Int
	Field _position:Vector2 = Vector2.Zero()
	
	Function Create:TBorder(width:Int, height:Int, borderWidth:Int, position:Vector2)
		Local b:TBorder = New TBorder
		b._width = width
		b._height = height
		b._borderWidth = borderWidth
		b._position = position.Copy()
		Return b
	End Function
	
	
	Method Draw()
		For Local i:Int = 0 To 3
			DrawImage(_texture[i], _geom[i].GetPosition().x, _geom[i].GetPosition().y)
		Next
	End Method
	
	Method Load(physics:TPhysicsSimulator)
		_texture = New TImage[4]
		Local color:TColor = TColor.Create(150, 200, 200, 200)
		_texture[0] = TDrawingHelper.CreateRectangleTexture(_borderWidth, _height, color.Copy(), TColor.White, 2)
		_texture[1] = TDrawingHelper.CreateRectangleTexture(_borderWidth, _height, color.Copy(), TColor.White, 2)
		_texture[2] = TDrawingHelper.CreateRectangleTexture(_width, _borderWidth, color.Copy(), TColor.White, 2)
		_texture[3] = TDrawingHelper.CreateRectangleTexture(_width, _borderWidth, color.Copy(), TColor.White, 2)
		For Local i:Int = 0 To 3
			MidHandleImage(_texture[i])
		Next
		_body = TBodyFactory.CreateRectangleBody(physics, _width, _height, 1)
		_body.SetStatic(True)
		_body.SetPosition(_position)
		
		LoadBorderGeom(physics)
	End Method
	
	Method LoadBorderGeom(physics:TPhysicsSimulator)
		Local geometryOffset:Vector2 = Vector2.Zero()
		
		' left
		geometryOffset = Vector2.Create(- (_width *.5 - _borderWidth *.5), 0)
		_geom = New TGeom[4]
		_geom[0] = TGeomFactory.CreateRectangleGeom(physics, _body, _borderWidth, _height, geometryOffset, 0)
		_geom[0].SetRestitutionCoefficient(.2)
		_geom[0].SetFrictionCoefficient(.5)
		_geom[0].SetCollisionGroup(100)
		_geom[0].SetCollisionGridCellSize(20)


		' right
		geometryOffset = Vector2.Create(_width *.5 - _borderWidth *.5, 0)
		_geom[1] = TGeomFactory.CloneGeom(physics, _body, _geom[0], geometryOffset, 0)
		
		' top
		geometryOffset = Vector2.Create(0, - (_height *.5 - _borderWidth *.5))
		_geom[2] = TGeomFactory.CreateRectangleGeom(physics, _body, _width, _borderWidth, geometryOffset, 0)
		_geom[2].SetRestitutionCoefficient(.2)
		_geom[2].SetFrictionCoefficient(.2)
		_geom[2].SetCollisionGroup(100)
		_geom[2].SetCollisionGridCellSize(20)

		
		'bottom (clone top)
		geometryOffset = Vector2.Create(0, _height *.5 - _borderWidth *.5)
		_geom[3] = TGeomFactory.CloneGeom(physics, _body, _geom[2], geometryOffset, 0)
		
	End Method
	
End Type
