
Type TAngularSpringLever

	Field _rectTexture:TImage
	Field _circleTexture:TImage
	
	Field _attachPoint:Int = 0 '0=left,1=top,2=right,3=bottom
	Field _rectangleWidth:Int = 100
	Field _rectangleHeight:Int = 20
	Field _position:Vector2 = Vector2.Zero()
	
	Field _springConstant:Float = 1
	Field _dampningConstant:Float = 1
	
	Field _angleSpringLeverBody:TBody
	Field _circleGeom:TGeom
	Field _rectGeom:TGeom
	
	Field _revoluteJoint:TFixedRevoluteJoint
	Field _fixedAngleSpring:TFixedAngleSpring
	
	Field _collisionGroup:Int = 0
	
	Method SetPosition(value:Vector2)
		_position.X = value.X
		_position.Y = value.Y
	End Method
	
	Method GetPosition:Vector2()
		Return _position.Copy()
	End Method
	
	Method SetAttachPoint(value:Int)
		_attachPoint = value
	End Method
	
	Method GetAttachPoint:Int()
		Return _attachPoint
	End Method
	
	Method GetRectangleWidth:Int()
		Return _rectangleWidth
	End Method
	
	Method SetRectangleWidth(value:Int)
		_rectangleWidth = value
	End Method
	
	Method GetRectangleHeight:Int()
		Return _rectangleHeight
	End Method
	
	Method SetRectangleHeight(value:Int)
		_rectangleHeight = value
	End Method
	
	Method GetSpringConstant:Float()
		Return _springConstant
	End Method
	
	Method SetSpringConstant(value:Int)
		_springConstant = value
	End Method
	
	Method GetDampningConstant:Float()
		Return _dampningConstant
	End Method
	
	Method SetDampningConstant(value:Int)
		_dampningConstant = value
	End Method
	
	Method GetCollisionGroup:Int()
		Return _collisionGroup
	End Method
	
	Method SetCollisionGroup(value:Int)
		_collisionGroup = value
	End Method
	
	Method GetBody:TBody()
		Return _angleSpringLeverBody
	End Method
	
	
	Method Draw()
		SetOrigin(_rectGeom.GetPosition().X, _rectGeom.GetPosition().Y)
		SetRotation(MathHelper.ToDegrees(_rectGeom.GetRotation()))
		DrawImage(_rectTexture, 0, 0)
			
		SetOrigin(_circleGeom.GetPosition().X, _circleGeom.GetPosition().Y)
		SetRotation(MathHelper.ToDegrees(_circleGeom.GetRotation()))
		DrawImage(_circleTexture, 0, 0)
		
		SetOrigin(0, 0)
		SetRotation(0)		
	End Method
	
	Method Load(physics:TPhysicsSimulator)
		_rectTexture = TDrawingHelper.CreateRectangleTexture(_rectangleWidth, _rectangleHeight, TColor.White, TColor.Black)
		MidHandleImage(_rectTexture)
		Local radius:Int = 0
		If _attachPoint = 0 Or _attachPoint = 2
			radius = _rectangleHeight
		Else
			radius = _rectangleWidth
		End If
		_circleTexture = TDrawingHelper.CreateCircleTexture(radius, TColor.White, TColor.Black)
		MidHandleImage(_circleTexture)
		
		_angleSpringLeverBody = TBodyFactory.CreateBody(physics, 1, TBodyFactory.MOIForRectangle(_rectangleWidth, _rectangleHeight, 1))
		
		_rectGeom = TGeomFactory.CreateRectangleGeom(physics, _angleSpringLeverBody, _rectangleWidth, _rectangleHeight)
		_rectGeom.SetFrictionCoefficient(.5)
		_rectGeom.SetCollisionGroup(_collisionGroup)
		
		Local offset:Vector2 = Vector2.Zero()
		Select _attachPoint
			Case 0
				offset.X = -_rectangleWidth / 2
			Case 1
				offset.Y = -_rectangleHeight / 2
			Case 2
				offset.X = _rectangleWidth / 2
			Case 3
				offset.Y = _rectangleHeight / 2			
		End Select
		
		_angleSpringLeverBody.SetPosition(Vector2.SubtractVectors(_position, offset))
		
		_circleGeom = TGeomFactory.CreateCircleGeom(physics, _angleSpringLeverBody, radius, 20, offset, 0)
		_circleGeom.SetFrictionCoefficient(.5)
		_circleGeom.SetCollisionGroup(_collisionGroup)
		
		_revoluteJoint = TJointFactory.CreateFixedRevoluteJoint(physics, _angleSpringLeverBody, _position)
		_fixedAngleSpring = TControllerFactory.CreateFixedAngleSpring(physics, _angleSpringLeverBody, _springConstant, _dampningConstant)
		
	End Method
End Type
