
Type TAgent

	Field agentTexture:TImage
	Field agentCrossBeamTexture:TImage
	
	Field agentBody:TBody
	Field agentGeom:TGeom[] 
	Field position:Vector2 = Vector2.Zero() 
	
	Field _collisionCategories:Int = CollisionCategories.All
	Field _collidesWith:Int = CollisionCategories.All
	Field _collisionGroup:Int = 1
	
	Method GetPosition:Vector2() 
		Return agentBody.GetPosition() 
	End Method
	
	Method GetDegrees:Float() 
		Return MathHelper.ToDegrees(agentBody.GetRotation()) 
	End Method
	
	Method GetCollisionGroup:Int()
		Return _collisionGroup
	End Method
	
	Method SetCollisionGroup(value:Int)
		_collisionGroup = value
	End Method
	
	Method SetCollisionCategories(value:Int)
		_collisionCategories = value
	End Method
	
	Method GetCollisionCategories:Int()
		Return _collisionCategories
	End Method
	
	
	Method SetCollidesWith(value:Int)
		_collidesWith = value
	End Method
	
	Method GetCollidesWith:Int()
		Return _collidesWith
	End Method
	
	Function Create:TAgent(position:Vector2) 
		Local a:TAgent = New TAgent
		a.position = position
		Return a
	End Function
	
	Method Load(physics:TPhysicsSimulator) 
		agentTexture = TDrawingHelper.CreateCircleTexture(16, TColor.Yellow, TColor.Black, 2) 
		agentCrossBeamTexture = TDrawingHelper.CreateRectangleTexture(16, 120, TColor.DarkGray, TColor.Black, 2) 
		MidHandleImage(agentTexture) 
		MidHandleImage(agentCrossBeamTexture) 
		 
		agentBody = TBodyFactory.CreateRectangleBody(physics, 80, 80, 5) 
		agentbody.SetPosition(position) 
		
		agentGeom = New TGeom[7] 
		agentGeom[0] = TGeomFactory.CreateCircleGeom(physics, agentBody, 16, 10, Vector2.Create(- 40, - 40), 0)
		agentGeom[0].SetRestitutionCoefficient(.4) 
		agentGeom[0].SetFrictionCoefficient(.2) 
		agentGeom[0].SetCollisionGroup(_collisionGroup)
		agentGeom[0].SetCollisionCategory(_collisionCategories)
		agentGeom[0].SetCollidesWith(_collidesWith)
		agentGeom[1] = TGeomFactory.CloneGeom(physics, agentBody, agentGeom[0], Vector2.Create(- 40, 40), 0)
		agentGeom[2] = TGeomFactory.CloneGeom(physics, agentBody, agentGeom[0], Vector2.Create(40, - 40), 0)
		agentGeom[3] = TGeomFactory.CloneGeom(physics, agentBody, agentGeom[0], Vector2.Create(40, 40), 0)
		agentGeom[4] = TGeomFactory.CloneGeom(physics, agentBody, agentGeom[0], Vector2.Create(0, 0), 0)
		
		agentGeom[5] = TGeomFactory.CreateRectangleGeom(physics, agentBody, 16, 130, Vector2.Zero(), MathHelper.PiOver4)
		agentGeom[5].SetCollisionGroup(_collisionGroup)
		agentGeom[5].SetCollisionCategory(_collisionCategories)
		agentGeom[5].SetCollidesWith(_collidesWith)
		
		agentGeom[6] = TGeomFactory.CreateRectangleGeom(physics, agentBody, 16, 130, Vector2.Zero(), - MathHelper.PiOver4)
		agentGeom[6].SetCollisionGroup(_collisionGroup)
		agentGeom[6].SetCollisionCategory(_collisionCategories)
		agentGeom[6].SetCollidesWith(_collidesWith)
	End Method
	
	Method Draw() 
		For Local i:Int = 5 To agentGeom.Length - 1
			Local geom:TGeom = agentGeom[i] 
			SetOrigin(geom.GetPosition().X, geom.GetPosition().Y) 
			SetRotation(MathHelper.ToDegrees(geom.GetRotation())) 
			DrawImage(agentCrossBeamTexture, 0, 0) 
		Next
		
		For Local i:Int = 0 To 4
			Local geom:TGeom = agentGeom[i] 
				SetOrigin(geom.GetPosition().X, geom.GetPosition().Y) 
			SetRotation(MathHelper.ToDegrees(geom.GetRotation())) 
			DrawImage(agentTexture, 0, 0) 
		Next
		SetOrigin(0, 0) 
		SetRotation(0) 
	End Method
End Type
