
Type Demo7Screen Extends TScreen
	
	Field agent:TAgent
	Field border:TBorder
	Field spiders:TSpider[]
	
	Method Draw(delta:Float)
		
		border.Draw()
		agent.Draw()
		
		For Local s:TSpider = EachIn spiders
			s.Draw()
		Next
		DrawMouseSpring()
		If physics.EnableDiagnostics Then
			view.Draw()
		End If
	End Method
	
	Field _firstRun:Int = True
	Method Update(delta:Float)
		If _firstRun Then
			 ScreenManager.Instance().AddScreen(TPauseScreen.Create(GetTitle(), GetDetails())) 
			_firstRun = False
		EndIf
		HandleKeyboardInput()
		HandleMouseInput()
		For Local i:Int = 0 To spiders.Length - 1
			spiders[i].Update(delta) 
		Next
		physics.Update(delta) 
	
	End Method
	
	
	Method HandleKeyboardInput()
		Local forceAmount:Float = 5000
		Local force:Vector2 = Vector2.Zero() 
		
		If KeyDown(KEY_A) Then force.X:+- forceAmount
		If KeyDown(KEY_S) Then force.Y:+forceAmount
		If KeyDown(KEY_D) Then force.X:+forceAmount
		If KeyDown(KEY_W) Then force.Y:+- forceAmount
		agent.agentBody.ApplyForce(force) 
		
		Local torqueAmount:Float = 14000
		Local torque:Float = 0
		If KeyDown(KEY_LEFT) Then torque:-torqueAmount
		If KeyDown(KEY_RIGHT) Then torque:+torqueAmount
		agent.agentBody.ApplyTorque(torque) 
		
		If KeyHit(KEY_F1) Then
			physics.EnableDiagnostics = Not physics.EnableDiagnostics
		End If
	End Method
	
	Method Load()
		physics = TPhysicsSimulator.Create(Vector2.Create(0, 150))
		physics.SetMaxContactsToDetect(5)
		physics.SetMaxContactsToResolve(2)
		physics.SetIterations(10) 
		physics.SetBiasFactor(.4)
		view = TPhysicsSimulatorView.Create(physics)

		
		Local center:Vector2 = Vector2.Create(TDemo.gfxWidth / 2.0, TDemo.gfxHeight / 2.0)
		Local borderWidth:Int = TDemo.gfxHeight *.05
		border = TBorder.Create(TDemo.gfxWidth, TDemo.gfxHeight, borderWidth, center)
		border.Load(physics)
		
		agent = TAgent.Create(Vector2.Create(center.X - 200, center.Y))
		agent._collisionCategories = CollisionCategories.Cat5
		agent._collidesWith = CollisionCategories.All & ~COllisionCategories.Cat4
		agent.Load(physics)
		agent.agentBody.SetLinearDragCoefficient(.001)
		
		LoadSpiders()
	End Method
	
	Method LoadSpiders()
		Local center:Vector2 = Vector2.Create(TDemo.gfxWidth / 2.0, TDemo.gfxHeight / 2.0)
		spiders = New TSpider[16] 
		For Local i:Int = 0 To spiders.Length - 1
			spiders[i] = TSpider.Create(Vector2.Create(center.X, (i + 1) * 30 + 150)) 
			spiders[i].SetCollisionGroup(1001 + i)
			spiders[i].Load(physics)
		Next
	End Method
	
	Method Unload()
		
	End Method
	
	Method OnEscapeKeyHit()
		ScreenManager.Instance().AddScreen(TPauseScreen.Create(GetTitle(), GetDetails()))
	End Method
	
	Method GetTitle:String()
		Return "Dynamic Angle Joints"
	End Method
	
	Method GetDetails:TStringBuilder()
		Local sb:TStringBuilder = New TStringBuilder
		sb.AppendLine("This demo demonstrates the use of revolute joints ")
		sb.AppendLine("combined with angle joints that have a dynamic ")
		sb.AppendLine("target angle")
		sb.AppendLine("")
		sb.AppendLine("Keyboard:")
		sb.AppendLine("  -Rotate : left and right arrows")
		sb.AppendLine("  -Move : A,S,D,W")
		sb.AppendLine("")
		sb.AppendLine("Mouse")
		sb.AppendLine("  -Hold down left button and drag")
		return sb
	End Method
End Type
