

Type Demo6Screen Extends TScreen
	
	Field border:TBorder
	Field agent:TAgent
	
	Field hangingTexture:TImage
	Field hangingBody:TBody
	Field hangingGeom:TGeom
	Field fixedLinearSpring1:TFixedLinearSpring
	
	Field angularSpringLever1:TAngularSpringLever
	Field angularSpringLever2:TAngularSpringLever
	Field angularSpringLever3:TAngularSpringLever
	Field angularSpringLever4:TAngularSpringLever
	
	Field linearSpring1:TLinearSpring
	Field springRectangleRope1:TSpringRectangleRope
	
	Field linearSpring2:TLinearSpring
	Field springRectangleRope2:TSpringRectangleRope
	
	Field platform1:TRectanglePlatform
	Field platform1WidthRatio:Float =.1
	Field platform1HeightRatio:Float =.6
	
	Field platform2:TRectanglePlatform
	Field platform2WidthRatio:Float =.1
	Field platform2HeightRatio:Float =.7
	
	Field platform3:TRectanglePlatform
	Field platform3WidthRatio:Float =.1
	Field platform3HeightRatio:Float =.6
	
	Field _floor:TRectanglePlatform
	
	Method Draw(delta:Float)
		
		border.Draw()
		platform1.Draw()
		platform2.Draw()
		platform3.Draw()
		agent.Draw()
		springRectangleRope1.Draw()
		springRectangleRope2.Draw()
		_floor.Draw()
		angularSpringLever1.Draw()
		angularSpringLever2.Draw()
		angularSpringLever3.Draw()
		angularSpringLever4.Draw()
		
		SetOrigin(hangingBody.GetPosition().X, hangingBody.GetPosition().Y)
		SetRotation(MathHelper.ToDegrees(hangingBody.GetRotation()))
		DrawImage(hangingTexture, 0, 0)
		SetOrigin(0, 0)
		setrotation(0)
		DrawMouseSpring()
		If physics.EnableDiagnostics Then
			view.Draw()
		End If
	End Method
	
	Field _firstRun:Int = True
	Method Update(delta:Float)
		If _firstRun Then
			 ScreenManager.Instance().AddScreen(TPauseScreen.Create(GetTitle(), GetDetails()))
			_firstRun = False
		EndIf
		HandleKeyboardInput()
		HandleMouseInput()
		physics.Update(delta)
		
	End Method
	
	Method Load()
		physics = TPhysicsSimulator.Create(Vector2.Create(0, 200))
		physics.SetMaxContactsToDetect(2)
		view = TPhysicsSimulatorView.Create(physics)
		view._enableVerticeView = False
		view._enableEdgeView = False
		
		Local borderWidth:Int = TDemo.gfxHeight *.05
		Local center:Vector2 = Vector2.Create(TDemo.gfxWidth / 2.0, TDemo.gfxHeight / 2.0)
		border = TBorder.Create(TDemo.gfxWidth + borderWidth * 2, TDemo.gfxHeight + borderWidth * 2, borderWidth, center)
		border.Load(physics)
		
		agent = TAgent.Create(Vector2.Create(center.X, 100))
		agent.SetCollisionCategories(CollisionCategories.Cat5)
		agent.SetCollidesWith(CollisionCategories.All & ~CollisionCategories.Cat4)
		agent.Load(physics)
		
		LoadPlatforms()
		
	End Method
	
	Method LoadPlatforms()
		Local center:Vector2 = Vector2.Create(TDemo.gfxWidth / 2.0, TDemo.gfxHeight / 2.0)
		
		Local width:Int = TDemo.gfxWidth * platform1WidthRatio
		Local height:Int = TDemo.gfxHeight * platform1HeightRatio
		Local position:Vector2 = Vector2.Create(- 5 + width / 2.0, 5 + TDemo.gfxHeight - height / 2.0)
		Local springPosition:Vector2 = Vector2.Zero()
		
		platform1 = TRectanglePlatform.Create(width, height, position, TColor.White, TColor.Black, 100)
		platform1.Load(physics)
		' do angular spring 1
		angularSpringLever1 = New TAngularSpringLever
		angularSpringLever1.SetAttachPoint(0)
		angularSpringLever1.SetRectangleWidth(200)
		angularSpringLever1.SetRectangleHeight(20)
		angularSpringLever1.SetSpringConstant(1000000)
		angularSpringLever1.SetDampningConstant(5000)
		angularSpringLever1.SetCollisionGroup(100)
		springPosition.Add(position)
		springPosition.Add(Vector2.Create(width / 2.0, - height / 2.0))
		springPosition.Add(Vector2.Create(- angularSpringLever1.GetRectangleHeight() - 5, .4 * height))
		angularSpringLever1.SetPosition(springPosition)
		angularSpringLever1.Load(physics)
		
		' platform 2		
		width = TDemo.gfxWidth * platform2WidthRatio
		height = TDemo.gfxHeight * platform2HeightRatio
		position = Vector2.Create(center.X, 5 + TDemo.gfxHeight - height / 2.0)
		
		platform2 = TRectanglePlatform.Create(width, height, position, TColor.White, TColor.Black, 100)
		platform2.Load(physics)
		
		'spring 2
		angularSpringLever2 = New TAngularSpringLever
		angularSpringLever2.SetAttachPoint(2)
		angularSpringLever2.SetRectangleWidth(200)
		angularSpringLever2.SetRectangleHeight(20)
		angularSpringLever2.SetSpringConstant(1000000)
		angularSpringLever2.SetDampningConstant(5000)
		angularSpringLever2.SetCollisionGroup(100)
		springPosition = Vector2.AddVectors(position, Vector2.Create(- width / 2.0, - height / 2.0))
		springPosition.Add(Vector2.Create(angularSpringLever2.GetRectangleHeight() + 5, .2 * height))
		angularSpringLever2.SetPosition(springPosition)
		angularSpringLever2.Load(physics)
		
		'spring 3
		angularSpringLever3 = New TAngularSpringLever
		angularSpringLever3.SetAttachPoint(0)
		angularSpringLever3.SetRectangleWidth(150)
		angularSpringLever3.SetRectangleHeight(20)
		angularSpringLever3.SetSpringConstant(1000000)
		angularSpringLever3.SetDampningConstant(1000)
		angularSpringLever3.SetCollisionGroup(100)
		springPosition = Vector2.AddVectors(position, Vector2.Create(width / 2.0, - height / 2.0))
		springPosition.Add(Vector2.Create(- angularSpringLever3.GetRectangleHeight() - 5, .1 * height))
		angularSpringLever3.SetPosition(springPosition)
		angularSpringLever3.Load(physics)
		
		'rope 1
		springRectangleRope1 = New TSpringRectangleRope		
		springRectangleRope1.SetPosition(Vector2.AddVectors(springPosition, Vector2.Create(angularSpringLever3.GetRectangleWidth() - 5, 25)))
		springRectangleRope1.SetRectangleCount(20)
		springRectangleRope1.SetRectangleWidth(15)
		springRectangleRope1.SetRectangleHeight(15)
		springRectangleRope1.SetRectangleMass(.5)
		springRectangleRope1.SetSpringLength(15)
		springRectangleRope1.SetSpringConstant(400)
		springRectangleRope1.SetDampningConstant(3)
		springRectangleRope1.Load(physics)
		linearSpring1 = TControllerFactory.CreateLinearSpring(physics, angularSpringLever3.GetBody(), Vector2.Create(angularSpringLever3.GetRectangleWidth() / 2.0, 0), springRectangleRope1.GetFirstBody(), Vector2.Zero(), 400, 3)
		
		'platform 3
		width = TDemo.gfxWidth * platform3WidthRatio
		height = TDemo.gfxHeight * platform3HeightRatio
		position = Vector2.Create(TDemo.gfxWidth + 4 - width / 2.0, 5 + TDemo.gfxHeight - height / 2.0)
		
		platform3 = TRectanglePlatform.Create(width, height, position, TColor.White, TColor.Black, 100)
		platform3.Load(physics)
		
		' hanging ball
		Self.hangingTexture = TDrawingHelper.CreateCircleTexture(40, TColor.White, TColor.Black)
		MidHandleImage(hangingTexture)
		
		hangingBody = TBodyFactory.CreateCircleBody(physics, 40, 1)
		hangingBody.SetPosition(Vector2.Create(position.X - 200, 200))
		hangingGeom = TGeomFactory.CreateCircleGeom(physics, hangingBody, 40, 20)
		fixedLinearSpring1 = TControllerFactory.CreateFixedLinearSpring(physics, hangingBody, Vector2.Create(0, - 35), Vector2.Create(position.X - 200, 100), 2, .1)
		
		'spring 4
		angularSpringLever4 = New TAngularSpringLever
		angularSpringLever4.SetAttachPoint(2)
		angularSpringLever4.SetRectangleWidth(200)
		angularSpringLever4.SetRectangleHeight(20)
		angularSpringLever4.SetSpringConstant(1000000)
		angularSpringLever4.SetDampningConstant(1000)
		angularSpringLever4.SetCollisionGroup(100)
		springPosition = Vector2.AddVectors(position, Vector2.Create(- width / 2.0, - height / 2.0))
		springPosition.Add(Vector2.Create(angularSpringLever4.GetRectangleHeight() + 5, .7 * height))
		angularSpringLever4.SetPosition(springPosition)
		angularSpringLever4.Load(physics)
		
		height = TDemo.gfxHeight *.05
		_floor = TRectanglePlatform.Create(TDemo.gfxWidth + 10, height, Vector2.Create(center.X, TDemo.gfxHeight + 5 - height / 2), TColor.White, TColor.Black, 0)
		_floor.Load(physics)
		
		springRectangleRope2 = New TSpringRectangleRope
		springRectangleRope2.SetPosition(Vector2.Create(center.X, 100))
		springRectangleRope2.SetRectangleCount(20)
		springRectangleRope2.SetRectangleWidth(10)
		springRectangleRope2.SetRectangleHeight(10)
		springRectangleRope2.SetRectangleMass(.2)
		springRectangleRope2.SetSpringLength(10)
		springRectangleRope2.SetSpringConstant(200)
		springRectangleRope2.SetDampningConstant(4)
		springRectangleRope2.SetCollisionGroup(1)
		springRectangleRope2.Load(physics)
		linearSpring2 = TControllerFactory.CreateLinearSpring(physics, agent.agentBody, Vector2.Zero(), springRectangleRope2.GetFirstBody(), Vector2.Zero(), 200, 4)
		
	End Method
	
	Method Unload()
		
	End Method

	Method HandleKeyboardInput()
		Local forceAmount:Float = 3000
		Local force:Vector2 = Vector2.Zero() 
		
		If KeyDown(KEY_A) Then force.X:+- forceAmount
		If KeyDown(KEY_S) Then force.Y:+forceAmount
		If KeyDown(KEY_D) Then force.X:+forceAmount
		If KeyDown(KEY_W) Then force.Y:+- forceAmount
		agent.agentBody.ApplyForce(force) 
		
		Local torqueAmount:Float = 14000
		Local torque:Float = 0
		If KeyDown(KEY_LEFT) Then torque:-torqueAmount
		If KeyDown(KEY_RIGHT) Then torque:+torqueAmount
		agent.agentBody.ApplyTorque(torque) 
		
		If KeyHit(KEY_F1) Then
			physics.EnableDiagnostics = Not physics.EnableDiagnostics
		End If
	End Method
	
	Method OnEscapeKeyHit()
		ScreenManager.Instance().AddScreen(TPauseScreen.Create(GetTitle(), GetDetails())) 
	End Method
	
	Method GetTitle:String()
		Return "Linear and Angular Springs"
	End Method
	
	Method GetDetails:TStringBuilder()
		Local sb:TStringBuilder = New TStringBuilder
		sb.AppendLine("This demo shows the use of angular and linear")
		sb.AppendLine("springs")
		sb.AppendLine("")
		sb.AppendLine("The levers are connected to the walls using")
		sb.AppendLine("revolute joints and they each have an angular")
		sb.AppendLine("spring attached.")
		sb.AppendLine("The hanging squares are connected by linear")
		sb.AppendLine("springs.")
		sb.AppendLine("")
		sb.AppendLine("Keyboard:")
		sb.AppendLine("  -Rotate : left and right arrows")
		sb.AppendLine("  -Move : A,S,D,W")
		sb.AppendLine("")
		sb.AppendLine("Mouse:")
		sb.AppendLine("  -Hold down left button and drag") 
		Return sb
	End Method
End Type
