
Type Demo5Screen Extends TScreen

	
	Field border:TBorder
	Field agent:TAgent
	
	Field redCircles1:TCircles
	Field redCircles2:TCircles
	Field redCircles3:TCircles
	
	Field blueCircles1:TCircles
	Field blueCircles2:TCircles
	Field blueCircles3:TCircles
	
	Field greenCircles1:TCircles
	Field greenCircles2:TCircles
	Field greenCircles3:TCircles
	
	Field blackCircles1:TCircles
	Field blackCircles2:TCircles
	Field blackCircles3:TCircles
	
	Field _firstRun:Int = True
	
	Method Draw(delta:Float)
		
		border.Draw()
		agent.Draw()
		
		redCircles1.Draw()
		redCircles2.Draw()
		redCircles3.Draw()
		
		greenCircles1.Draw()
		greenCircles2.Draw()
		greenCircles3.Draw()
		
		blueCircles1.Draw()
		blueCircles2.Draw()
		blueCircles3.Draw()
		
		blackCircles1.Draw()
		blackCircles2.Draw()
		blackCircles3.Draw()
		DrawMouseSpring()
		If physics.EnableDiagnostics Then
			view.Draw()
		End If
	End Method
	
	Method Update(delta:Float)
		If _firstRun Then
			 ScreenManager.Instance().AddScreen(TPauseScreen.Create(GetTitle(), GetDetails()))
			_firstRun = False
		EndIf
		HandleKeyBoardInput()
		HandleMouseInput()
		physics.Update(delta)
	End Method
	
	
	Method HandleKeyboardInput()
		Local forceAmount:Float = 800
		Local force:Vector2 = Vector2.Zero() 
		
		If KeyDown(KEY_A) Then force.X:+- forceAmount
		If KeyDown(KEY_S) Then force.Y:+forceAmount
		If KeyDown(KEY_D) Then force.X:+forceAmount
		If KeyDown(KEY_W) Then force.Y:+- forceAmount
		agent.agentBody.ApplyForce(force) 
		
		Local torqueAmount:Float = 10000
		Local torque:Float = 0
		If KeyDown(KEY_LEFT) Then torque:-torqueAmount
		If KeyDown(KEY_RIGHT) Then torque:+torqueAmount
		agent.agentBody.ApplyTorque(torque) 
		
		If KeyHit(KEY_F1) Then
			physics.EnableDiagnostics = Not physics.EnableDiagnostics
		End If
	End Method
	
	Method Load()
		physics = TPhysicsSimulator.Create(Vector2.Create(0, 0))
		view = TPhysicsSimulatorView.Create(physics)
		physics.SetMaxContactsToDetect(2)

		
		Local center:Vector2 = Vector2.Create(TDemo.gfxWidth / 2, TDemo.gfxHeight / 2)
		Local borderWidth:Int = TDemo.gfxHeight *.05
		border = TBorder.Create(TDemo.gfxWidth, TDemo.gfxHeight, borderWidth, center)
		border.Load(physics)
		
		agent = TAgent.Create(center)
		agent.SetCollisionCategories(CollisionCategories.Cat5)
		agent.SetCollidesWith(CollisionCategories.All & ~CollisionCategories.Cat4) ' collides with all but cat4 (black)
		agent.Load(physics)
		
		LoadCircles()
	End Method
	
	Method LoadCircles()
		Local startPosition:Vector2 = Vector2.Zero()
		Local endPosition:Vector2 = Vector2.Zero()
		
		'cat1 =red, cat2=green, cat3=blue,cat4=black,cat5=agent
		startPosition.SetParts(100, 100)
		endPosition.SetParts(100, TDemo.gfxHeight - 100)
		redCircles1 = TCircles.Create(startPosition, endPosition, 15, 15, TColor.Create(175, 200, 0, 0), TColor.Black)
		redCircles1.SetCollisionCategories(CollisionCategories.Cat1)
		redCircles1.SetCollidesWith(CollisionCategories.Cat1 | CollisionCategories.Cat4 | CollisionCategories.Cat5)
		redCircles1.Load(physics)
		
		startPosition.SetParts(200, 200)
		endPosition.SetParts(200, TDemo.gfxHeight - 200)
		redCircles2 = TCircles.Create(startPosition, endPosition, 15, 12, TColor.Create(175, 200, 0, 0), TColor.Black)
		redCircles2.SetCollisionCategories(CollisionCategories.Cat1)
		redCircles2.SetCollidesWith(CollisionCategories.Cat1 | CollisionCategories.Cat4 | CollisionCategories.Cat5)
		redCircles2.Load(physics)
		
		startPosition.SetParts(300, 300)
		endPosition.SetParts(300, TDemo.gfxHeight - 300)
		redCircles3 = TCircles.Create(startPosition, endPosition, 10, 9, TColor.Create(175, 200, 0, 0), TColor.Black)
		redCircles3.SetCollisionCategories(CollisionCategories.Cat1)
		redCircles3.SetCollidesWith(CollisionCategories.Cat1 | CollisionCategories.Cat4 | CollisionCategories.Cat5)
		redCircles3.Load(physics)
		
		'green
		startPosition.SetParts(200, 100)
		endPosition.SetParts(TDemo.gfxWidth - 200, 100)
		greenCircles1 = TCircles.Create(startPosition, endPosition, 15, 15, TColor.Create(175, 0, 200, 0), TColor.Black)
		greenCircles1.SetCollisionCategories(CollisionCategories.Cat2)
		greenCircles1.SetCollidesWith(CollisionCategories.Cat2 | CollisionCategories.Cat4 | CollisionCategories.Cat5)
		greenCircles1.Load(physics)
		
		startPosition.SetParts(300, 200)
		endPosition.SetParts(TDemo.gfxWidth - 300, 200)
		greenCircles2 = TCircles.Create(startPosition, endPosition, 15, 12, TColor.Create(175, 0, 200, 0), TColor.Black)
		greenCircles2.SetCollisionCategories(CollisionCategories.Cat2)
		greenCircles2.SetCollidesWith(CollisionCategories.Cat2 | CollisionCategories.Cat4 | CollisionCategories.Cat5)
		greenCircles2.Load(physics)
		
		startPosition.SetParts(400, 300)
		endPosition.SetParts(TDemo.gfxWidth - 400, 300)
		greenCircles3 = TCircles.Create(startPosition, endPosition, 10, 9, TColor.Create(175, 0, 200, 0), TColor.Black)
		greenCircles3.SetCollisionCategories(CollisionCategories.Cat2)
		greenCircles3.SetCollidesWith(CollisionCategories.Cat2 | CollisionCategories.Cat4 | CollisionCategories.Cat5)
		greenCircles3.Load(physics)
		
		startPosition.SetParts(TDemo.gfxWidth - 100, 100)
		endPosition.SetParts(TDemo.gfxWidth - 100, TDemo.gfxHeight - 100)
		blueCircles1 = TCircles.Create(startPosition, endPosition, 15, 15, TColor.Create(175, 0, 0, 200), TColor.Black)
		blueCircles1.SetCollisionCategories(CollisionCategories.Cat3)
		blueCircles1.SetCollidesWith(CollisionCategories.Cat3 | CollisionCategories.Cat4 | CollisionCategories.Cat5)
		blueCircles1.Load(physics)
		
		startPosition.SetParts(TDemo.gfxWidth - 200, 200)
		endPosition.SetParts(TDemo.gfxWidth - 200, TDemo.gfxHeight - 200)
		blueCircles2 = TCircles.Create(startPosition, endPosition, 15, 12, TColor.Create(175, 0, 0, 200), TColor.Black)
		blueCircles2.SetCollisionCategories(CollisionCategories.Cat3)
		blueCircles2.SetCollidesWith(CollisionCategories.Cat3 | CollisionCategories.Cat4 | CollisionCategories.Cat5)
		blueCircles2.Load(physics)
		
		startPosition.SetParts(TDemo.gfxWidth - 300, 300)
		endPosition.SetParts(TDemo.gfxWidth - 300, TDemo.gfxHeight - 300)
		blueCircles3 = TCircles.Create(startPosition, endPosition, 10, 9, TColor.Create(175, 0, 0, 200), TColor.Black)
		blueCircles3.SetCollisionCategories(CollisionCategories.Cat3)
		blueCircles3.SetCollidesWith(CollisionCategories.Cat3 | CollisionCategories.Cat4 | CollisionCategories.Cat5)
		blueCircles3.Load(physics)
		
		startPosition.SetParts(200, TDemo.gfxHeight - 100)
		endPosition.SetParts(TDemo.gfxWidth - 200, TDemo.gfxHeight - 100)
		blackCircles1 = TCircles.Create(startPosition, endPosition, 15, 15, TColor.Create(200, 0, 0, 0), TColor.Black)
		blackCircles1.SetCollisionCategories(CollisionCategories.Cat4)
		blackCircles1.SetCollidesWith(CollisionCategories.All & ~CollisionCategories.Cat5) ' collide with all but cat5
		blackCircles1.Load(physics)
		
		startPosition.SetParts(300, TDemo.gfxHeight - 200)
		endPosition.SetParts(TDemo.gfxWidth - 300, TDemo.gfxHeight - 200)
		blackCircles2 = TCircles.Create(startPosition, endPosition, 15, 12, TColor.Create(200, 0, 0, 0), TColor.Black)
		blackCircles2.SetCollisionCategories(CollisionCategories.Cat4)
		blackCircles2.SetCollidesWith(CollisionCategories.All & ~CollisionCategories.Cat5) ' collide with all but cat5
		blackCircles2.Load(physics)
		
		startPosition.SetParts(400, TDemo.gfxHeight - 300)
		endPosition.SetParts(TDemo.gfxWidth - 400, TDemo.gfxHeight - 300)
		blackCircles3 = TCircles.Create(startPosition, endPosition, 10, 9, TColor.Create(200, 0, 0, 0), TColor.Black)
		blackCircles3.SetCollisionCategories(CollisionCategories.Cat4)
		blackCircles3.SetCollidesWith(CollisionCategories.All & ~CollisionCategories.Cat5) ' collide with all but cat5
		blackCircles3.Load(physics)
		
	End Method
	
	Method Unload()
		
	End Method
	
	Method OnEscapeKeyHit()
		ScreenManager.Instance().AddScreen(TPauseScreen.Create(GetTitle(), GetDetails())) 
	End Method
	
	Method GetTitle:String()
		Return "Collision Categories"
	End Method
	
	Method GetDetails:TStringBuilder()
		Local sb:TStringBuilder = New TStringBuilder
		sb.AppendLine("This demo shows how to setup complex collision")
		sb.AppendLine("scenerios.")
		sb.AppendLine("In this demo:")
		sb.AppendLine("-Red, Green, and Blue are set to only collide with")
		sb.AppendLine(" their own color.")
		sb.AppendLine("-Black is set to collide with itself, Red, Green, ")
		sb.AppendLine(" and Blue.")
		sb.AppendLine("-The 'Agent' (the cross thing) is set to collide")
		sb.AppendLine(" with all but Black")
		sb.AppendLine("")
		sb.AppendLine("NOTE: If two objects define conflicting")
		sb.AppendLine("collision status, collide wins over not colliding.")
		sb.AppendLine("This is the case with Black vs. the Red, Green, ")
		sb.AppendLine("and Blue circles")
		sb.AppendLine("")
		sb.AppendLine("")
		sb.AppendLine("Keyboard:")
		sb.AppendLine("  -Rotate : left and right arrows")
		sb.AppendLine("  -Move : A,S,D,W")
		sb.AppendLine("")
		sb.AppendLine("Mouse:")
		sb.AppendLine("  -Hold down left button and drag")
		return sb
	End Method
End Type
