
Type TFloor

	Field floorTexture:TImage
	Field floorBody:TBody
	Field floorGeom:TGeom
	
	Field width:Float
	Field height:Float
	Field position:Vector2 = Vector2.Zero() 
	
	Function Create:TFloor(width:Float, height:Float, position:Vector2) 
		Local f:TFloor = New TFloor
		f.width = width
		f.height = height
		f.position = position.Copy() 
		Return f
	End Function
	
	Method Load(physics:TPhysicsSimulator) 
		floorTexture = TDrawingHelper.CreateRectangleTexture(TDemo.gfxWidth, 100, TColor.White, TColor.Black, 2) 
		MidHandleImage(floorTexture) 
		
		floorBody = TBodyFactory.CreateRectangleBody(physics, TDemo.gfxWidth, 100, 1) 
		floorBody.SetStatic(True) 
		floorGeom = TGeomFactory.CreateRectangleGeom(physics, floorBody, TDemo.gfxWidth, 100)
		floorGeom.SetRestitutionCoefficient(.2) 
		floorGeom.SetFrictionCoefficient(.2) 
		floorBody.SetPosition(Vector2.Create(TDemo.gfxWidth / 2, TDemo.gfxHeight - 50)) 
	End Method
	
	Method Draw() 
		DrawImage(floorTexture, floorBody.GetPosition().X, floorBody.GetPosition().Y) 	
	End Method
End Type
