
Type Demo4Screen Extends TScreen

	Field agent:TAgent
	Field _floor:TFloor
	Field pyramid:TPyramid
	Field pyramidBaseBodyCount:Int = 16
	Field rectangleTexture:TImage

	Method Draw(delta:Float) 
		_floor.Draw() 
		pyramid.Draw(rectangleTexture) 
		agent.Draw()
		DrawMouseSpring()
		If physics.EnableDiagnostics Then
			view.Draw() 
		End If
	End Method
	
	Field _firstRun:Int = True
	Method Update(delta:Float)
		If _firstRun Then
			 ScreenManager.Instance().AddScreen(TPauseScreen.Create(GetTitle(), GetDetails())) 
			_firstRun = False
		EndIf
		HandleKeyBoardInput()
		HandleMouseInput()
		physics.Update(delta)
	End Method
	
	Method Load() 
		rectangleTexture = TDrawingHelper.CreateRectangleTexture(32, 32, TColor.White, TColor.Black, 2)
		MidHandleImage(rectangleTexture)
		
		physics = TPhysicsSimulator.Create(Vector2.Create(0, 50))
		physics.SetBiasFactor(.4) 
		physics.SetMaxContactsToDetect(2) 
		view = TPhysicsSimulatorView.Create(physics) 
		
		Local rectangleBody:TBody = TBodyFactory.CreateRectangleBody(Null, 32, 32, 1)
		Local rectangleGeom:TGeom = TGeomFactory.CreateRectangleGeom(Null, rectangleBody, 32, 32)
		rectangleGeom.SetFrictionCoefficient(.4) 
		rectangleGeom.SetRestitutionCoefficient(0) 
		
		pyramid = TPyramid.Create(rectangleBody, rectangleGeom, 32.0 / 3.0, 32.0 / 3, 32, 32, pyramidBaseBodyCount, Vector2.Create((TDemo.gfxWidth / 2) - pyramidBaseBodycount *.5 * (32 + 32 / 3), TDemo.gfxHeight - 125)) 
		pyramid.Load(physics)
		
		_floor = TFloor.Create(TDemo.gfxWidth, 100, Vector2.Create(TDemo.gfxWidth / 2, TDemo.gfxHeight - 50))
		_floor.Load(physics)  
		
		agent = TAgent.Create(Vector2.Create(TDemo.gfxWidth / 2 - 320, TDemo.gfxHeight / 2 - 300))
		agent.Load(physics) 
	End Method
	
	Method Unload() 
		
	End Method
	
	Method OnEscapeKeyHit() 
		ScreenManager.Instance().AddScreen(TPauseScreen.Create(GetTitle(), GetDetails())) 
	End Method
	
	Method GetTitle:String() 
		Return "Stacked Bodies"
	End Method
	
	Method GetDetails:TStringBuilder()
		Local sb:TStringBuilder = New TStringBuilder
		sb.AppendLine("This demo shows the stacking stability of the engine.")
		sb.AppendLine("It shows a stack of rectangular bodies stacked in")
		sb.AppendLine("the shape of a pyramid.")
		sb.AppendLine("")
		sb.AppendLine ("Keyboard:")
		sb.AppendLine ("  -Rotate : left and right arrows")
		sb.AppendLine ("  -Move : A,S,D,W")
		sb.AppendLine("")
		sb.AppendLine("Mouse:")
		sb.AppendLine("  -Hold down left button and drag")
		Return sb
	End Method
	
	Method HandleKeyboardInput() 
		Local forceAmount:Float = 1000
		Local force:Vector2 = Vector2.Zero() 
		
		If KeyDown(KEY_A) Then force.X:+- forceAmount
		If KeyDown(KEY_S) Then force.Y:+forceAmount
		If KeyDown(KEY_D) Then force.X:+forceAmount
		If KeyDown(KEY_W) Then force.Y:+- forceAmount
		agent.agentBody.ApplyForce(force) 
		
		Local torqueAmount:Float = 14000
		Local torque:Float = 0
		If KeyDown(KEY_LEFT) Then torque:-torqueAmount
		If KeyDown(KEY_RIGHT) Then torque:+torqueAmount
		agent.agentBody.ApplyTorque(torque) 
		
		If KeyHit(KEY_F1) Then
			physics.EnableDiagnostics = Not physics.EnableDiagnostics
		End If
	End Method
End Type
