
Type Demo2Screen Extends TScreen
	
	Field lineBrush:TLineBrush = TLineBrush.Create(1, TColor.Black)
	Field lastMouseDown:Int
	Field currentMouseDown:Int
	Field mousePickSpring:TFixedLinearSpring
	
	Field _rectTex:TImage
	Field _circleTex:TImage
	
	Field _rectBody:TBody
	Field _circleBody:TBody
	
	Field _rectGeom:TGeom
	Field _circleGeom:TGeom
	
	Field _firstRun:Int = True

	
	Method New() 

	End Method
	
	
	Method Update(delta:Float) 
		If _firstRun Then
			 ScreenManager.Instance().AddScreen(TPauseScreen.Create(GetTitle(), GetDetails())) 
			_firstRun = False
		EndIf
		HandleKeyboardInput()
		HandleMouseInput()
		physics.Update(delta)
	End Method
	
	Method Draw(delta:Float) 
		
		Local pos:Vector2 = _rectBody.GetPosition() 
		Local rot:Float = MathHelper.ToDegrees(_rectBody.GetRotation()) 
		SetRotation(rot) 
		SetOrigin(pos.X, pos.Y) 
		DrawImage(_rectTex, 0, 0) 
		
		pos = _circleBody.GetPosition() 
		rot = MathHelper.ToDegrees(_circleBody.GetRotation()) 
		SetRotation(rot) 
		SetOrigin(pos.X, pos.Y) 
		DrawImage(_circleTex, 0, 0) 
		
		SetRotation(0) 
		SetOrigin(0, 0) 
		SetColor(255, 255, 255)
		
		DrawMouseSpring()
		
		If physics.EnableDiagnostics Then
			view.Draw()
		End If
	End Method
	
	Method HandleKeyboardInput() 
		Local forceAmount:Float = 500
		Local force:Vector2 = Vector2.Zero() 
		
		If KeyDown(KEY_A) Then force.X:+- forceAmount
		If KeyDown(KEY_S) Then force.Y:+forceAmount
		If KeyDown(KEY_D) Then force.X:+forceAmount
		If KeyDown(KEY_W) Then force.Y:+- forceAmount
		_rectBody.ApplyForce(force) 
		
		Local torqueAmount:Float = 10000
		Local torque:Float = 0
		If KeyDown(KEY_LEFT) Then torque:-torqueAmount
		If KeyDown(KEY_RIGHT) Then torque:+torqueAmount
		_rectBody.ApplyTorque(torque) 
		
		If KeyHit(KEY_F1) Then
			physics.EnableDiagnostics = Not physics.EnableDiagnostics
		End If
	End Method
	
	
	
	Method Load()		
		physics = TPhysicsSimulator.Create(Vector2.Zero())
		view:TPhysicsSimulatorView = TPhysicsSimulatorView.Create(physics)
		view._enableGridView = True
			
		_rectTex = TDrawingHelper.CreateRectangleTexture(128, 128, TColor.Yellow, TColor.Black, 2) 
		_circleTex = TDrawingHelper.CreateCircleTexture(64, TColor.White, TColor.Black, 2) 
		MidHandleImage(_rectTex) 
		MidHandleImage(_circleTex) 
		
		_rectBody = TBodyFactory.CreateRectangleBody(physics, 128, 128, 1)
		_rectBody.SetPosition(Vector2.Create(256, 384)) 
		'_rectBody.SetPosition(Vector2.Create(200, 300)) 
		_rectGeom = TGeomFactory.CreateRectangleGeom(physics, _rectBody, 128, 128)

		_circleBody = TBodyFactory.CreateCircleBody(physics, 64, 1)
		_circleBody.SetPosition(Vector2.Create(725, 384)) 
		'_circleBody.SetPosition(Vector2.Create(600, 300)) 
		_circleGeom = TGeomFactory.CreateCircleGeom(physics, _circleBody, 64, 20)
		
		_rectBody.ApplyForce(Vector2.Create(7000, 0)) 
		
	End Method
	
	Method Unload() 
		physics.Clear()
	End Method
	
	Method OnEscapeKeyHit() 
		ScreenManager.Instance().AddScreen(TPauseScreen.Create(GetTitle(), GetDetails())) 
	End Method
	
	Method GetTitle:String() 
		Return "Two Bodies with Geometry"
	End Method
	
	Method GetDetails:TStringBuilder()
		Local sb:TStringBuilder = New TStringBuilder
		sb.AppendLine("This demo shows two bodies each with a single geometry")
		sb.AppendLine("object attached.")
		sb.AppendLine("")
		sb.AppendLine("Keyboard:")
		sb.AppendLine("  -Rotate : left and right arrows")
		sb.AppendLine("  -Move : A,S,D,W")
		sb.AppendLine("")
		sb.AppendLine("Mouse:")
		sb.AppendLine("  -Hold down left button and drag")
		return sb
	End Method
End Type
