Type Demo1Screen Extends TScreen
	
	Field lineBrush:TLineBrush = TLineBrush.Create(1, TColor.Black)
	Field lastMouseDown:Int
	Field currentMouseDown:Int
	Field mousePickSpring:TFixedLinearSpring
	
	Field rectangleBody:TBody
	Field bodyTexture:TImage
	Field _firstRun:Int = True
	
	Method Draw(delta:Float) 
		Local pos:Vector2 = rectangleBody.GetPosition() 
		SetOrigin(pos.X, pos.Y) 
		SetRotation(MathHelper.ToDegrees(rectangleBody.GetRotation())) 
		SetColor(255, 255, 255) 
		DrawImage(bodyTexture, 0, 0) 
		SetColor(0, 0, 0) 
		DrawOval(0, 0, 5, 5) 
		
		SetRotation(0) 
		SetOrigin(0, 0) 
		SetColor(255, 255, 255)
		DrawMouseSpring()
		If physics.EnableDiagnostics Then
			view.Draw()
		End If
	End Method
	
		
	Method Update(delta:Float) 
		If _firstRun Then
			_firstRun = False
			ScreenManager.Instance().AddScreen(TPauseScreen.Create(GetTItle(), GetDetails())) 
		End If
		HandleKeyboardInput()
		HandleMouseInput()
		physics.Update(delta)
	End Method
	
	Method Load() 

		physics = TPhysicsSimulator.Create(Vector2.Create(0, 0))
		view = TPhysicsSimulatorView.Create(physics)

		rectangleBody = TBodyFactory.CreateRectangleBody(physics, 128, 128, 1)
		rectangleBody.SetPosition(Vector2.Create(400, 300)) 
		bodyTexture = TDrawingHelper.CreateRectangleTexture(128, 128, TColor.Create(255, 255, 255, 0), TColor.Create(255, 0, 0, 0), 4) 
		MidHandleImage(bodyTexture)
	End Method
	
	Method Unload() 
		physics.Clear()
	End Method

	
	Method HandleKeyboardInput() 
		Local forceAmount:Float = 50
		Local force:Vector2 = Vector2.Zero() 
		
		If KeyDown(KEY_A) Then force.X:+- forceAmount
		If KeyDown(KEY_S) Then force.Y:+forceAmount
		If KeyDown(KEY_D) Then force.X:+forceAmount
		If KeyDown(KEY_W) Then force.Y:+- forceAmount
		rectangleBody.ApplyForce(force) 
		
		Local torqueAmount:Float = 1000
		Local torque:Float = 0
		If KeyDown(KEY_LEFT) Then torque:-torqueAmount
		If KeyDown(KEY_RIGHT) Then torque:+torqueAmount
		rectangleBody.ApplyTorque(torque) 
		
		If KeyHit(KEY_F1) Then
			physics.EnableDiagnostics = Not physics.EnableDiagnostics
		End If
	End Method
	
		
	Method OnEscapeKeyHit() 
			ScreenManager.Instance().AddScreen(TPauseScreen.Create(gettitle(), getdetails())) 
	End Method
	
	Method GetTitle:String() 
		Return "Basic Geometry"
	End Method
	
	Method GetDetails:TStringBuilder()
		Local sb:TStringBuilder = New TStringBuilder
		sb.AppendLine("This demo shows a single body with no geometry")
		sb.AppendLine("attached.")
		sb.AppendLine("")
		sb.AppendLine("Keyboard:")
		sb.AppendLine("  -Rotate : left and right arrows")
		sb.AppendLine("  -Move : A,S,D,W")
		Return sb
	End Method
End Type
